% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotr.R
\name{dtab.pivotr}
\alias{dtab.pivotr}
\title{Make a pivot tabel in DT}
\usage{
\method{dtab}{pivotr}(object, format = "none", perc = FALSE, dec = 3,
  searchCols = NULL, order = NULL, pageLength = NULL, ...)
}
\arguments{
\item{object}{Return value from \code{\link{pivotr}}}

\item{format}{Show Color bar ("color_bar"),  Heat map ("heat"), or None ("none")}

\item{perc}{Display numbers as percentages (TRUE or FALSE)}

\item{dec}{Number of decimals to show}

\item{searchCols}{Column search and filter. Used to save and restore state}

\item{order}{Column sorting. Used to save and restore state}

\item{pageLength}{Page length. Used to save and restore state}

\item{...}{further arguments passed to or from other methods}
}
\description{
Make a pivot tabel in DT
}
\details{
See \url{http://radiant-rstats.github.io/docs/data/pivotr.html} for an example in Radiant
}
\examples{
pivotr("diamonds", cvars = "cut") \%>\% dtab
pivotr("diamonds", cvars = c("cut","clarity")) \%>\% dtab(format = "color_bar")
ret <-  pivotr("diamonds", cvars = c("cut","clarity"), normalize = "total") \%>\%
   dtab(format = "color_bar", perc = TRUE)

}
\seealso{
\code{\link{pivotr}} to create the pivot-table using dplyr

\code{\link{summary.pivotr}} to print a plain text table
}

