% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rWishart-package.R, R/rWishart.R
\docType{package}
\name{rWishart}
\alias{rWishart}
\alias{rWishart-package}
\alias{rWishart}
\title{Random Wishart Matrix Generation}
\usage{
rWishart(n, df, Sigma, covariance = FALSE, simplify = "array")
}
\arguments{
\item{n}{integer: the number of replications.}

\item{df}{numeric parameter, \dQuote{degrees of freedom}.}

\item{Sigma}{positive definite (\eqn{p\times p}{p * p}) \dQuote{scale}
    matrix, the matrix parameter of the distribution.}

\item{covariance}{logical on whether a covariance matrix should be generated}

\item{simplify}{logical or character string; should the result be
    simplified to a vector, matrix or higher dimensional array if
    possible?  For \code{sapply} it must be named and not abbreviated.
    The default value, \code{TRUE}, returns a vector or matrix if appropriate,
    whereas if \code{simplify = "array"} the result may be an
    \code{\link{array}} of \dQuote{rank}
    (\eqn{=}\code{length(dim(.))}) one higher than the result
    of \code{FUN(X[[i]])}.}
}
\value{
A numeric array of dimension \code{p * p * n}, where each array is a positive semidefinite matrix, a realization of the Wishart distribution W_p(Sigma, df)
}
\description{
An expansion of R's 'stats' random wishart matrix generation. 
This package allows the user to generate singular, Uhlig and Harald (1994) 
<doi:10.1214/aos/1176325375>, and pseudo wishart, Diaz-Garcia, et al.(1997) 
<doi:10.1006/jmva.1997.1689>, matrices. In addition the user can generate 
wishart matrices with fractional degrees of freedom, Adhikari (2008) 
<doi:10.1061/(ASCE)0733-9399(2008)134:12(1029)>, commonly used in volatility 
modeling. Users can also use this package to create random covariance matrices.

Generate \code{n} random matrices, distributed according to the Wishart distribution with parameters \code{Sigma} and \code{df}, W_p(Sigma, df).
}
\details{
If X_1, ..., X_m is a sample of m independent multivariate Gaussians with mean vector 0, and covariance matrix Sigma, 
the distribution of M = X'X is W_p(Sigma, m).
}
\examples{
rWishart(2, 5, diag(1, 20))
}
