% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_match_exact.R
\name{wcvp_match_exact}
\alias{wcvp_match_exact}
\title{Exact matching to WCVP.}
\usage{
wcvp_match_exact(names_df, wcvp_names, name_col, author_col = NULL, id_col)
}
\arguments{
\item{names_df}{Data frame of names for matching.}

\item{wcvp_names}{Data frame of taxonomic names from WCVP version 7 or later.
If \code{NULL} (the default), names will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{\code{rWCVPdata::wcvp_names}}.}

\item{name_col}{Character. The column in \code{names_df} that has the taxon name
for matching.}

\item{author_col}{the column in \code{names_df} that has the name authority, to aid
matching. Set to \code{NULL} to match with no author string.}

\item{id_col}{the column in \code{names_df} that has the observation id.}
}
\value{
Match results from WCVP bound to the original data from \code{names_df}.
}
\description{
Exact matching of names to the WCVP, optionally using the author string to
refine results.
}
\examples{
\donttest{ # these examples require 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
wcvp_names <- rWCVPdata::wcvp_names

# including author string
wcvp_match_exact(redlist_example, wcvp_names, "scientificName",
  author_col = "authority",
  id_col = "assessmentId"
)

# without author string
wcvp_match_exact(redlist_example, wcvp_names, "scientificName", id_col = "assessmentId")
}
}

}
\seealso{
Other name matching functions: 
\code{\link{wcvp_match_fuzzy}()},
\code{\link{wcvp_match_names}()}
}
\concept{name matching functions}
