% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rTensor_Class.R
\docType{methods}
\name{[-methods}
\alias{[-methods}
\alias{[,Tensor-method}
\alias{extract,Tensor-method}
\alias{[<-,Tensor-method}
\title{Extract or Replace Subtensors}
\usage{
\S4method{[}{Tensor}(x, i, j, ..., drop = TRUE)

\S4method{[}{Tensor}(x, i, j, ...) <- value
}
\arguments{
\item{x}{Tensor to be subset}

\item{i, j, ...}{indices that specify the extents of the sub-tensor}

\item{drop}{whether or not to reduce the number of modes to exclude those that have '1' as the mode}

\item{value}{either vector, matrix, or array that will replace the subtensor}
}
\value{
an object of class Tensor
}
\description{
Extends '[' and '[<-' from the base array class for the Tensor class. Works exactly as it would for the base 'array' class.
}
\details{
\code{x[i,j,...,drop=TRUE]}
}
\examples{
tnsr <- rand_tensor()
tnsr[1,2,3]
tnsr[3,1,]
tnsr[,,5]
tnsr[,,5,drop=FALSE]

tnsr[1,2,3] <- 3; tnsr[1,2,3]
tnsr[3,1,] <- rep(0,5); tnsr[3,1,]
tnsr[,2,] <- matrix(0,nrow=3,ncol=5); tnsr[,2,]
}
