/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.io.IOException;
import org.python.core.Py;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedMethod;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.expose.TypeBuilder;
import org.python.expose.generate.ExposedTypeProcessor;
import org.python.expose.generate.InterpTestCase;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.SimpleExposed;

public class TypeExposerTest
extends InterpTestCase {
    public void testMakeBuilder() throws Exception {
        ExposedTypeProcessor etp = new ExposedTypeProcessor(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/python/expose/generate/SimpleExposed.class"));
        TypeBuilder t = etp.getTypeExposer().makeBuilder();
        TypeExposerTest.assertEquals((String)"simpleexposed", (String)t.getName());
        TypeExposerTest.assertEquals(SimpleExposed.class, (Object)t.getTypeClass());
        PyType type = PyType.fromClass(SimpleExposed.class);
        PyObject dict = t.getDict(type);
        TypeExposerTest.assertNotNull((Object)dict.__finditem__("simple_method"));
        TypeExposerTest.assertNotNull((Object)dict.__finditem__("prefixed"));
        TypeExposerTest.assertNotNull((Object)dict.__finditem__("__str__"));
        TypeExposerTest.assertNotNull((Object)dict.__finditem__("__repr__"));
        TypeExposerTest.assertNotNull((Object)dict.__finditem__("tostring"));
        dict.__finditem__("tostring").__get__(new SimpleExposed(), type);
    }

    public void testGoodNew() throws IOException {
        ExposedTypeProcessor etp = new ExposedTypeProcessor(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/python/expose/generate/TypeExposerTest$SimplestNew.class"));
        TypeBuilder te = etp.getTypeExposer().makeBuilder();
        PyObject new_ = te.getDict(PyType.fromClass(SimplestNew.class)).__finditem__("__new__");
        TypeExposerTest.assertEquals((Object)Py.One, (Object)new_.__call__(PyType.fromClass(SimplestNew.class)));
    }

    public void testCatchingDupes() throws IOException {
        try {
            new ExposedTypeProcessor(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/python/expose/generate/TypeExposerTest$DupeMethodNames.class"));
            TypeExposerTest.fail((String)"Shouldn't be able to create a type with identical names in the dict");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }

    @ExposedType
    public static class SimplestNew {
        @ExposedNew
        public static PyObject __new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
            return Py.One;
        }
    }

    @ExposedType
    public class NonstaticNew {
        @ExposedNew
        public PyObject __new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
            return null;
        }
    }

    @ExposedType
    public static class DupeMethodNames {
        @ExposedMethod
        public void blah() {
        }

        @ExposedMethod(names={"blah"})
        public void bleh() {
        }
    }
}

