/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assert;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.AugAssign;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.Break;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.Compare;
import org.python.antlr.ast.Continue;
import org.python.antlr.ast.Delete;
import org.python.antlr.ast.Dict;
import org.python.antlr.ast.Ellipsis;
import org.python.antlr.ast.Exec;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.Global;
import org.python.antlr.ast.If;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.List;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Pass;
import org.python.antlr.ast.Print;
import org.python.antlr.ast.Raise;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.Subscript;
import org.python.antlr.ast.Suite;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.comprehensionType;
import org.python.antlr.ast.excepthandlerType;
import org.python.antlr.ast.exprType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.keywordType;
import org.python.antlr.ast.modType;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.stmtType;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Future;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.compiler.SymInfo;
import org.python.core.CompilerFlags;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.objectweb.asm.ClassWriter;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;
import org.python.objectweb.asm.commons.Method;

public class CodeCompiler
extends Visitor
implements Opcodes,
ClassConstants {
    public static final Object Exit = new Integer(1);
    public static final Object NoExit = null;
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int DEL = 2;
    public static final int AUGGET = 3;
    public static final int AUGSET = 4;
    public Module module;
    public ClassWriter cw;
    public Code code;
    public CodeCompiler mrefs;
    public CompilerFlags cflags;
    int temporary;
    expr_contextType augmode;
    int augtmp1;
    int augtmp2;
    int augtmp3;
    int augtmp4;
    public boolean fast_locals;
    public boolean print_results;
    public Map<String, SymInfo> tbl;
    public ScopeInfo my_scope;
    boolean optimizeGlobals = true;
    public Vector names;
    public String className;
    public Stack continueLabels;
    public Stack breakLabels;
    public Stack exceptionHandlers;
    public Vector yields = new Vector();
    public int bcfLevel = 0;
    int yield_count = 0;
    private int stackDepth = 0;

    public CodeCompiler(Module module, boolean print_results) {
        this.module = module;
        this.print_results = print_results;
        this.mrefs = this;
        this.cw = module.classfile.cw;
        this.continueLabels = new Stack();
        this.breakLabels = new Stack();
        this.exceptionHandlers = new Stack();
    }

    public void getNone() throws IOException {
        this.code.getstatic("org/python/core/Py", "None", "Lorg/python/core/PyObject;");
    }

    public void loadFrame() throws Exception {
        this.code.aload(1);
    }

    public void setLastI(int idx) throws Exception {
        this.loadFrame();
        this.code.iconst(idx);
        this.code.putfield("org/python/core/PyFrame", "f_lasti", "I");
    }

    private void loadf_back() throws Exception {
        this.code.getfield("org/python/core/PyFrame", "f_back", "Lorg/python/core/PyFrame;");
    }

    public int storeTop() throws Exception {
        int tmp = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(tmp);
        return tmp;
    }

    public void setline(int line) throws Exception {
        if (this.module.linenumbers) {
            this.loadFrame();
            this.code.iconst(line);
            this.code.invokevirtual("org/python/core/PyFrame", "setline", "(I)V");
        }
    }

    public void setline(PythonTree node) throws Exception {
        this.setline(node.getLine());
    }

    public void set(PythonTree node) throws Exception {
        int tmp = this.storeTop();
        this.set(node, tmp);
        this.code.aconst_null();
        this.code.astore(tmp);
        this.code.freeLocal(tmp);
    }

    public void set(PythonTree node, int tmp) throws Exception {
        this.temporary = tmp;
        this.visit(node);
    }

    private void saveAugTmps(PythonTree node, int count) throws Exception {
        if (count >= 4) {
            this.augtmp4 = this.code.getLocal("Lorg/python/core/PyObject;");
            this.code.astore(this.augtmp4);
        }
        if (count >= 3) {
            this.augtmp3 = this.code.getLocal("Lorg/python/core/PyObject;");
            this.code.astore(this.augtmp3);
        }
        if (count >= 2) {
            this.augtmp2 = this.code.getLocal("Lorg/python/core/PyObject;");
            this.code.astore(this.augtmp2);
        }
        this.augtmp1 = this.code.getLocal("Lorg/python/core/PyObject;");
        this.code.astore(this.augtmp1);
        this.code.aload(this.augtmp1);
        if (count >= 2) {
            this.code.aload(this.augtmp2);
        }
        if (count >= 3) {
            this.code.aload(this.augtmp3);
        }
        if (count >= 4) {
            this.code.aload(this.augtmp4);
        }
    }

    private void restoreAugTmps(PythonTree node, int count) throws Exception {
        this.code.aload(this.augtmp1);
        this.code.freeLocal(this.augtmp1);
        if (count == 1) {
            return;
        }
        this.code.aload(this.augtmp2);
        this.code.freeLocal(this.augtmp2);
        if (count == 2) {
            return;
        }
        this.code.aload(this.augtmp3);
        this.code.freeLocal(this.augtmp3);
        if (count == 3) {
            return;
        }
        this.code.aload(this.augtmp4);
        this.code.freeLocal(this.augtmp4);
    }

    public void parse(modType node, Code code, boolean fast_locals, String className, boolean classBody, ScopeInfo scope, CompilerFlags cflags) throws Exception {
        this.fast_locals = fast_locals;
        this.className = className;
        this.code = code;
        this.cflags = cflags;
        this.my_scope = scope;
        this.names = scope.names;
        this.tbl = scope.tbl;
        boolean bl = this.optimizeGlobals = fast_locals && !scope.exec && !scope.from_import_star;
        if (scope.max_with_count > 0) {
            this.loadFrame();
            code.iconst(scope.max_with_count);
            code.anewarray("org/python/core/PyObject");
            code.putfield("org/python/core/PyFrame", "f_exits", "[Lorg/python/core/PyObject;");
        }
        Object exit = this.visit(node);
        if (classBody) {
            this.loadFrame();
            code.invokevirtual("org/python/core/PyFrame", "getf_locals", "()Lorg/python/core/PyObject;");
            code.areturn();
        } else if (exit == null) {
            this.setLastI(-1);
            this.getNone();
            code.areturn();
        }
    }

    public Object visitInteractive(Interactive node) throws Exception {
        this.traverse(node);
        return null;
    }

    public Object visitModule(org.python.antlr.ast.Module suite) throws Exception {
        if (suite.body.length > 0 && suite.body[0] instanceof Expr && ((Expr)suite.body[0]).value instanceof Str) {
            this.loadFrame();
            this.code.ldc("__doc__");
            this.visit(((Expr)suite.body[0]).value);
            this.code.invokevirtual("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        if (this.module.setFile) {
            this.loadFrame();
            this.code.ldc("__file__");
            this.module.filename.get(this.code);
            this.code.invokevirtual("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
        }
        this.traverse(suite);
        return null;
    }

    public Object visitExpression(Expression node) throws Exception {
        if (this.my_scope.generator && node.body != null) {
            this.module.error("'return' with argument inside generator", true, node);
        }
        return this.visitReturn(new Return(node, node.body), true);
    }

    public int makeArray(PythonTree[] nodes) throws Exception {
        int n = nodes == null ? 0 : nodes.length;
        int array = this.code.getLocal("[Lorg/python/core/PyObject;");
        if (n == 0) {
            this.code.getstatic("org/python/core/Py", "EmptyObjects", "[Lorg/python/core/PyObject;");
            this.code.astore(array);
        } else {
            this.code.iconst(n);
            this.code.anewarray("org/python/core/PyObject");
            this.code.astore(array);
            for (int i = 0; i < n; ++i) {
                this.visit(nodes[i]);
                this.code.aload(array);
                this.code.swap();
                this.code.iconst(i);
                this.code.swap();
                this.code.aastore();
            }
        }
        return array;
    }

    public void getDocString(stmtType[] suite) throws Exception {
        if (suite.length > 0 && suite[0] instanceof Expr && ((Expr)suite[0]).value instanceof Str) {
            this.visit(((Expr)suite[0]).value);
        } else {
            this.code.aconst_null();
        }
    }

    public boolean makeClosure(ScopeInfo scope) throws Exception {
        if (scope == null || scope.freevars == null) {
            return false;
        }
        int n = scope.freevars.size();
        if (n == 0) {
            return false;
        }
        int tmp = this.code.getLocal("[Lorg/python/core/PyObject;");
        this.code.iconst(n);
        this.code.anewarray("org/python/core/PyObject");
        this.code.astore(tmp);
        Map<String, SymInfo> upTbl = scope.up.tbl;
        for (int i = 0; i < n; ++i) {
            this.code.aload(tmp);
            this.code.iconst(i);
            this.loadFrame();
            for (int j = 1; j < scope.distance; ++j) {
                this.loadf_back();
            }
            SymInfo symInfo = upTbl.get(scope.freevars.elementAt(i));
            this.code.iconst(symInfo.env_index);
            this.code.invokevirtual("org/python/core/PyFrame", "getclosure", "(I)Lorg/python/core/PyObject;");
            this.code.aastore();
        }
        this.code.aload(tmp);
        this.code.freeLocal(tmp);
        return true;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        String name = this.getName(node.name);
        this.setline(node);
        ScopeInfo scope = this.module.getScopeInfo(node);
        int defaults = this.makeArray(scope.ac.getDefaults());
        this.code.new_("org/python/core/PyFunction");
        this.code.dup();
        this.loadFrame();
        this.code.getfield("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        this.code.aload(defaults);
        this.code.freeLocal(defaults);
        scope.setup_closure();
        scope.dump();
        this.module.PyCode(new Suite(node, node.body), name, true, this.className, false, false, node.getLine(), scope, this.cflags).get(this.code);
        this.getDocString(node.body);
        if (!this.makeClosure(scope)) {
            this.code.invokespecial("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)V");
        } else {
            this.code.invokespecial("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)V");
        }
        this.set(new Name(node, node.name, expr_contextType.Store));
        this.doDecorators(node, node.decorators, node.name);
        return null;
    }

    private void doDecorators(stmtType node, exprType[] decs, String name) throws Exception {
        if (decs.length > 0) {
            exprType currentExpr = new Name(node, name, expr_contextType.Load);
            for (int i = decs.length - 1; i > -1; --i) {
                currentExpr = new Call(node, decs[i], new exprType[]{currentExpr}, new keywordType[0], null, null);
            }
            this.visit(currentExpr);
            this.set(new Name(node, name, expr_contextType.Store));
        }
    }

    public Object visitExpr(Expr node) throws Exception {
        this.setline(node);
        this.visit(node.value);
        if (this.print_results) {
            this.code.invokestatic("org/python/core/Py", "printResult", "(Lorg/python/core/PyObject;)V");
        } else {
            this.code.pop();
        }
        return null;
    }

    public Object visitAssign(Assign node) throws Exception {
        this.setline(node);
        this.visit(node.value);
        if (node.targets.length == 1) {
            this.set(node.targets[0]);
        } else {
            int tmp = this.storeTop();
            for (exprType target : node.targets) {
                this.set(target, tmp);
            }
            this.code.freeLocal(tmp);
        }
        return null;
    }

    public Object visitPrint(Print node) throws Exception {
        this.setline(node);
        int tmp = -1;
        if (node.dest != null) {
            this.visit(node.dest);
            tmp = this.storeTop();
        }
        if (node.values == null || node.values.length == 0) {
            if (node.dest != null) {
                this.code.aload(tmp);
                this.code.invokestatic("org/python/core/Py", "printlnv", "(Lorg/python/core/PyObject;)V");
            } else {
                this.code.invokestatic("org/python/core/Py", "println", "()V");
            }
        } else {
            for (int i = 0; i < node.values.length; ++i) {
                if (node.dest != null) {
                    this.code.aload(tmp);
                    this.visit(node.values[i]);
                    if (node.nl && i == node.values.length - 1) {
                        this.code.invokestatic("org/python/core/Py", "println", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                        continue;
                    }
                    this.code.invokestatic("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                    continue;
                }
                this.visit(node.values[i]);
                if (node.nl && i == node.values.length - 1) {
                    this.code.invokestatic("org/python/core/Py", "println", "(Lorg/python/core/PyObject;)V");
                    continue;
                }
                this.code.invokestatic("org/python/core/Py", "printComma", "(Lorg/python/core/PyObject;)V");
            }
        }
        if (node.dest != null) {
            this.code.freeLocal(tmp);
        }
        return null;
    }

    public Object visitDelete(Delete node) throws Exception {
        this.setline(node);
        this.traverse(node);
        return null;
    }

    public Object visitPass(Pass node) throws Exception {
        this.setline(node);
        return null;
    }

    public Object visitBreak(Break node) throws Exception {
        if (this.breakLabels.empty()) {
            throw new ParseException("'break' outside loop", node);
        }
        this.doFinallysDownTo(this.bcfLevel);
        this.code.goto_((Label)this.breakLabels.peek());
        return null;
    }

    public Object visitContinue(Continue node) throws Exception {
        if (this.continueLabels.empty()) {
            throw new ParseException("'continue' not properly in loop", node);
        }
        this.doFinallysDownTo(this.bcfLevel);
        this.code.goto_((Label)this.continueLabels.peek());
        return Exit;
    }

    public Object visitYield(Yield node) throws Exception {
        this.setline(node);
        if (!this.fast_locals) {
            throw new ParseException("'yield' outside function", node);
        }
        int stackState = this.saveStack();
        if (node.value != null) {
            this.visit(node.value);
        } else {
            this.getNone();
        }
        this.setLastI(++this.yield_count);
        this.saveLocals();
        this.code.areturn();
        Label restart = new Label();
        this.yields.addElement(restart);
        this.code.label(restart);
        this.restoreLocals();
        this.restoreStack(stackState);
        this.loadFrame();
        this.code.invokevirtual("org/python/core/PyFrame", "getGeneratorInput", "()Ljava/lang/Object;");
        this.code.dup();
        this.code.instanceof_("org/python/core/PyException");
        Label done2 = new Label();
        this.code.ifeq(done2);
        this.code.checkcast("java/lang/Throwable");
        this.code.athrow();
        this.code.label(done2);
        this.code.checkcast("org/python/core/PyObject");
        return null;
    }

    private void stackProduce() {
        ++this.stackDepth;
    }

    private void stackConsume() {
        --this.stackDepth;
    }

    private void stackConsume(int numItems) {
        this.stackDepth -= numItems;
    }

    private int saveStack() throws Exception {
        if (this.stackDepth > 0) {
            int array = this.code.getLocal("[Lorg/python/core/PyObject;");
            this.code.iconst(this.stackDepth);
            this.code.anewarray("org/python/core/PyObject");
            this.code.astore(array);
            for (int i = 0; i < this.stackDepth; ++i) {
                this.code.aload(array);
                this.code.swap();
                this.code.iconst(i);
                this.code.swap();
                this.code.aastore();
            }
            return array;
        }
        return -1;
    }

    private void restoreStack(int array) throws Exception {
        if (this.stackDepth > 0) {
            for (int i = this.stackDepth - 1; i >= 0; --i) {
                this.code.aload(array);
                this.code.iconst(i);
                this.code.aaload();
            }
            this.code.freeLocal(array);
        }
    }

    private boolean inFinallyBody() {
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            if (!handler.isFinallyHandler()) continue;
            return true;
        }
        return false;
    }

    private void restoreLocals() throws Exception {
        this.endExceptionHandlers();
        Vector v = this.code.getActiveLocals();
        this.loadFrame();
        this.code.getfield("org/python/core/PyFrame", "f_savedlocals", "[Ljava/lang/Object;");
        int locals = this.code.getLocal("[Ljava/lang/Object;");
        this.code.astore(locals);
        for (int i = 0; i < v.size(); ++i) {
            String type = (String)v.elementAt(i);
            if (type == null) continue;
            this.code.aload(locals);
            this.code.iconst(i);
            this.code.aaload();
            this.code.checkcast(type);
            this.code.astore(i);
        }
        this.code.freeLocal(locals);
        this.restartExceptionHandlers();
    }

    private void endExceptionHandlers() {
        Label end = new Label();
        this.code.label(end);
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            handler.exceptionEnds.addElement(end);
        }
    }

    private void restartExceptionHandlers() {
        Label start = new Label();
        this.code.label(start);
        for (int i = 0; i < this.exceptionHandlers.size(); ++i) {
            ExceptionHandler handler = (ExceptionHandler)this.exceptionHandlers.elementAt(i);
            handler.exceptionStarts.addElement(start);
        }
    }

    private void saveLocals() throws Exception {
        Vector v = this.code.getActiveLocals();
        this.code.iconst(v.size());
        this.code.anewarray("java/lang/Object");
        int locals = this.code.getLocal("[Ljava/lang/Object;");
        this.code.astore(locals);
        for (int i = 0; i < v.size(); ++i) {
            String type = (String)v.elementAt(i);
            if (type == null) continue;
            this.code.aload(locals);
            this.code.iconst(i);
            if (i == 2222) {
                this.code.aconst_null();
            } else {
                this.code.aload(i);
            }
            this.code.aastore();
        }
        this.loadFrame();
        this.code.aload(locals);
        this.code.putfield("org/python/core/PyFrame", "f_savedlocals", "[Ljava/lang/Object;");
        this.code.freeLocal(locals);
    }

    public Object visitReturn(Return node) throws Exception {
        return this.visitReturn(node, false);
    }

    public Object visitReturn(Return node, boolean inEval) throws Exception {
        this.setline(node);
        if (!inEval && !this.fast_locals) {
            throw new ParseException("'return' outside function", node);
        }
        int tmp = 0;
        if (node.value != null) {
            if (this.my_scope.generator) {
                throw new ParseException("'return' with argument inside generator", node);
            }
            this.visit(node.value);
            tmp = this.code.getReturnLocal();
            this.code.astore(tmp);
        }
        this.doFinallysDownTo(0);
        this.setLastI(-1);
        if (node.value != null) {
            this.code.aload(tmp);
        } else {
            this.getNone();
        }
        this.code.areturn();
        return Exit;
    }

    public Object visitRaise(Raise node) throws Exception {
        this.setline(node);
        if (node.type != null) {
            this.visit(node.type);
            this.stackProduce();
        }
        if (node.inst != null) {
            this.visit(node.inst);
            this.stackProduce();
        }
        if (node.tback != null) {
            this.visit(node.tback);
            this.stackProduce();
        }
        if (node.type == null) {
            this.code.invokestatic("org/python/core/Py", "makeException", "()Lorg/python/core/PyException;");
        } else if (node.inst == null) {
            this.stackConsume();
            this.code.invokestatic("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
        } else if (node.tback == null) {
            this.stackConsume(2);
            this.code.invokestatic("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
        } else {
            this.stackConsume(3);
            this.code.invokestatic("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
        }
        this.code.athrow();
        return Exit;
    }

    public Object visitImport(Import node) throws Exception {
        this.setline(node);
        for (int i = 0; i < node.names.length; ++i) {
            String name;
            String asname = null;
            if (node.names[i].asname != null) {
                name = node.names[i].name;
                asname = node.names[i].asname;
                this.code.ldc(name);
                this.loadFrame();
                this.code.invokestatic("org/python/core/imp", "importOneAs", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
            } else {
                name = node.names[i].name;
                asname = name;
                if (asname.indexOf(46) > 0) {
                    asname = asname.substring(0, asname.indexOf(46));
                }
                this.code.ldc(name);
                this.loadFrame();
                this.code.invokestatic("org/python/core/imp", "importOne", "(Ljava/lang/String;Lorg/python/core/PyFrame;)Lorg/python/core/PyObject;");
            }
            this.set(new Name(node.names[i], asname, expr_contextType.Store));
        }
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        Future.checkFromFuture(node);
        this.setline(node);
        this.code.ldc(node.module);
        if (node.names.length == 1 && node.names[0].name.equals("*")) {
            if (node.level > 0) {
                throw new ParseException("'import *' not allowed with 'from .'", node);
            }
            if (this.my_scope.func_level > 0) {
                this.module.error("import * only allowed at module level", false, node);
                if (this.my_scope.contains_ns_free_vars) {
                    this.module.error("import * is not allowed in function '" + this.my_scope.scope_name + "' because it contains a nested function with free variables", true, node);
                }
            }
            if (this.my_scope.func_level > 1) {
                this.module.error("import * is not allowed in function '" + this.my_scope.scope_name + "' because it is a nested function", true, node);
            }
            this.loadFrame();
            this.code.invokestatic("org/python/core/imp", "importAll", "(Ljava/lang/String;Lorg/python/core/PyFrame;)V");
        } else {
            String[] fromNames = new String[node.names.length];
            String[] asnames = new String[node.names.length];
            for (int i = 0; i < node.names.length; ++i) {
                fromNames[i] = node.names[i].name;
                asnames[i] = node.names[i].asname;
                if (asnames[i] != null) continue;
                asnames[i] = fromNames[i];
            }
            int strArray = CodeCompiler.makeStrings(this.code, fromNames, fromNames.length);
            this.code.aload(strArray);
            this.code.freeLocal(strArray);
            this.loadFrame();
            if (node.level == 0) {
                if (this.module.getFutures().isAbsoluteImportOn()) {
                    this.code.iconst_0();
                } else {
                    this.code.iconst_m1();
                }
            } else {
                this.code.iconst(node.level);
            }
            this.code.invokestatic("org/python/core/imp", "importFrom", "(Ljava/lang/String;[Ljava/lang/String;Lorg/python/core/PyFrame;I)[Lorg/python/core/PyObject;");
            int tmp = this.storeTop();
            for (int i = 0; i < node.names.length; ++i) {
                this.code.aload(tmp);
                this.code.iconst(i);
                this.code.aaload();
                this.set(new Name(node.names[i], asnames[i], expr_contextType.Store));
            }
            this.code.freeLocal(tmp);
        }
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        return null;
    }

    public Object visitExec(Exec node) throws Exception {
        this.setline(node);
        this.visit(node.body);
        this.stackProduce();
        if (node.globals != null) {
            this.visit(node.globals);
        } else {
            this.code.aconst_null();
        }
        this.stackProduce();
        if (node.locals != null) {
            this.visit(node.locals);
        } else {
            this.code.aconst_null();
        }
        this.stackProduce();
        this.stackConsume(3);
        this.code.invokestatic("org/python/core/Py", "exec", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        return null;
    }

    public Object visitAssert(Assert node) throws Exception {
        this.setline(node);
        Label end_of_assert = new Label();
        this.loadFrame();
        this.emitGetGlobal("__debug__");
        this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
        this.code.ifeq(end_of_assert);
        this.visit(node.test);
        this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
        this.code.ifne(end_of_assert);
        if (node.msg != null) {
            this.visit(node.msg);
        } else {
            this.getNone();
        }
        this.code.getstatic("org/python/core/Py", "AssertionError", "Lorg/python/core/PyObject;");
        this.code.swap();
        this.code.invokestatic("org/python/core/Py", "makeException", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyException;");
        this.code.athrow();
        this.code.label(end_of_assert);
        return null;
    }

    public Object doTest(Label end_of_if, If node, int index) throws Exception {
        Label end_of_suite = new Label();
        this.setline(node.test);
        this.visit(node.test);
        this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
        this.code.ifeq(end_of_suite);
        Object exit = this.suite(node.body);
        if (end_of_if != null && exit == null) {
            this.code.goto_(end_of_if);
        }
        this.code.label(end_of_suite);
        if (node.orelse != null) {
            return this.suite(node.orelse) != null ? exit : null;
        }
        return null;
    }

    public Object visitIf(If node) throws Exception {
        Label end_of_if = null;
        if (node.orelse != null) {
            end_of_if = new Label();
        }
        Object exit = this.doTest(end_of_if, node, 0);
        if (end_of_if != null) {
            this.code.label(end_of_if);
        }
        return exit;
    }

    public Object visitIfExp(IfExp node) throws Exception {
        this.setline(node.test);
        Label end = new Label();
        Label end_of_else = new Label();
        this.visit(node.test);
        this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
        this.code.ifeq(end_of_else);
        this.visit(node.body);
        this.code.goto_(end);
        this.code.label(end_of_else);
        this.visit(node.orelse);
        this.code.label(end);
        return null;
    }

    public int beginLoop() {
        this.continueLabels.push(new Label());
        this.breakLabels.push(new Label());
        int savebcf = this.bcfLevel;
        this.bcfLevel = this.exceptionHandlers.size();
        return savebcf;
    }

    public void finishLoop(int savebcf) {
        this.continueLabels.pop();
        this.breakLabels.pop();
        this.bcfLevel = savebcf;
    }

    public Object visitWhile(While node) throws Exception {
        int savebcf = this.beginLoop();
        Label continue_loop = (Label)this.continueLabels.peek();
        Label break_loop = (Label)this.breakLabels.peek();
        Label start_loop = new Label();
        this.code.goto_(continue_loop);
        this.code.label(start_loop);
        this.suite(node.body);
        this.code.label(continue_loop);
        this.setline(node);
        this.visit(node.test);
        this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
        this.code.ifne(start_loop);
        this.finishLoop(savebcf);
        if (node.orelse != null) {
            this.suite(node.orelse);
        }
        this.code.label(break_loop);
        return null;
    }

    public Object visitFor(For node) throws Exception {
        int savebcf = this.beginLoop();
        Label continue_loop = (Label)this.continueLabels.peek();
        Label break_loop = (Label)this.breakLabels.peek();
        Label start_loop = new Label();
        Label next_loop = new Label();
        int iter_tmp = this.code.getLocal("org/python/core/PyObject");
        int expr_tmp = this.code.getLocal("org/python/core/PyObject");
        this.setline(node);
        this.visit(node.iter);
        this.code.invokevirtual("org/python/core/PyObject", "__iter__", "()Lorg/python/core/PyObject;");
        this.code.astore(iter_tmp);
        this.code.goto_(next_loop);
        this.code.label(start_loop);
        this.set(node.target, expr_tmp);
        this.suite(node.body);
        this.code.label(continue_loop);
        this.code.label(next_loop);
        this.setline(node);
        this.code.aload(iter_tmp);
        this.code.invokevirtual("org/python/core/PyObject", "__iternext__", "()Lorg/python/core/PyObject;");
        this.code.astore(expr_tmp);
        this.code.aload(expr_tmp);
        this.code.ifnonnull(start_loop);
        this.finishLoop(savebcf);
        if (node.orelse != null) {
            this.suite(node.orelse);
        }
        this.code.label(break_loop);
        this.code.freeLocal(iter_tmp);
        this.code.freeLocal(expr_tmp);
        return null;
    }

    public void exceptionTest(int exc, Label end_of_exceptions, TryExcept node, int index) throws Exception {
        for (int i = 0; i < node.handlers.length; ++i) {
            excepthandlerType handler = node.handlers[i];
            Label end_of_self = new Label();
            if (handler.type != null) {
                this.code.aload(exc);
                this.visit(handler.type);
                this.code.invokestatic("org/python/core/Py", "matchException", "(Lorg/python/core/PyException;Lorg/python/core/PyObject;)Z");
                this.code.ifeq(end_of_self);
            } else if (i != node.handlers.length - 1) {
                throw new ParseException("default 'except:' must be last", handler);
            }
            if (handler.name != null) {
                this.code.aload(exc);
                this.code.getfield("org/python/core/PyException", "value", "Lorg/python/core/PyObject;");
                this.set(handler.name);
            }
            this.suite(handler.body);
            this.code.goto_(end_of_exceptions);
            this.code.label(end_of_self);
        }
        this.code.aload(exc);
        this.code.athrow();
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        Label start = new Label();
        Label end = new Label();
        Label handlerStart = new Label();
        Label finallyEnd = new Label();
        ExceptionHandler inFinally = new ExceptionHandler(node);
        this.exceptionHandlers.push(inFinally);
        int excLocal = this.code.getLocal("java/lang/Throwable");
        this.code.aconst_null();
        this.code.astore(excLocal);
        this.code.label(start);
        inFinally.exceptionStarts.addElement(start);
        Object ret = this.suite(node.body);
        this.code.label(end);
        inFinally.exceptionEnds.addElement(end);
        inFinally.bodyDone = true;
        this.exceptionHandlers.pop();
        if (ret == NoExit) {
            this.inlineFinally(inFinally);
            this.code.goto_(finallyEnd);
        }
        this.code.label(handlerStart);
        this.code.astore(excLocal);
        this.code.aload(excLocal);
        this.loadFrame();
        this.code.invokestatic("org/python/core/Py", "addTraceback", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)V");
        this.inlineFinally(inFinally);
        this.code.aload(excLocal);
        this.code.checkcast("java/lang/Throwable");
        this.code.athrow();
        this.code.label(finallyEnd);
        this.code.freeLocal(excLocal);
        inFinally.addExceptionHandlers(handlerStart);
        return null;
    }

    private void inlineFinally(ExceptionHandler handler) throws Exception {
        if (!handler.bodyDone) {
            Label end = new Label();
            this.code.label(end);
            handler.exceptionEnds.addElement(end);
        }
        if (handler.isFinallyHandler()) {
            this.suite(((TryFinally)handler.node).finalbody);
        }
    }

    private void reenterProtectedBody(ExceptionHandler handler) throws Exception {
        Label restart = new Label();
        this.code.label(restart);
        handler.exceptionStarts.addElement(restart);
    }

    private void doFinallysDownTo(int level) throws Exception {
        ExceptionHandler handler;
        Stack<ExceptionHandler> poppedHandlers = new Stack<ExceptionHandler>();
        while (this.exceptionHandlers.size() > level) {
            handler = (ExceptionHandler)this.exceptionHandlers.pop();
            this.inlineFinally(handler);
            poppedHandlers.push(handler);
        }
        while (poppedHandlers.size() > 0) {
            handler = (ExceptionHandler)poppedHandlers.pop();
            this.reenterProtectedBody(handler);
            this.exceptionHandlers.push(handler);
        }
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        Label start = new Label();
        Label end = new Label();
        Label handler_start = new Label();
        Label handler_end = new Label();
        ExceptionHandler handler = new ExceptionHandler();
        this.code.label(start);
        handler.exceptionStarts.addElement(start);
        this.exceptionHandlers.push(handler);
        Object exit = this.suite(node.body);
        this.exceptionHandlers.pop();
        this.code.label(end);
        handler.exceptionEnds.addElement(end);
        if (exit == null) {
            this.code.goto_(handler_end);
        }
        this.code.label(handler_start);
        this.loadFrame();
        this.code.invokestatic("org/python/core/Py", "setException", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)Lorg/python/core/PyException;");
        int exc = this.code.getFinallyLocal("java/lang/Throwable");
        this.code.astore(exc);
        if (node.orelse == null) {
            this.exceptionTest(exc, handler_end, node, 1);
            this.code.label(handler_end);
        } else {
            Label else_end = new Label();
            this.exceptionTest(exc, else_end, node, 1);
            this.code.label(handler_end);
            this.suite(node.orelse);
            this.code.label(else_end);
        }
        this.code.freeFinallyLocal(exc);
        handler.addExceptionHandlers(handler_start);
        return null;
    }

    public Object visitSuite(Suite node) throws Exception {
        return this.suite(node.body);
    }

    public Object suite(stmtType[] stmts) throws Exception {
        int n = stmts.length;
        for (int i = 0; i < n; ++i) {
            Object exit = this.visit(stmts[i]);
            if (exit == null) continue;
            return Exit;
        }
        return null;
    }

    public Object visitBoolOp(BoolOp node) throws Exception {
        Label end = new Label();
        this.visit(node.values[0]);
        for (int i = 1; i < node.values.length; ++i) {
            this.code.dup();
            this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
            switch (node.op) {
                case Or: {
                    this.code.ifne(end);
                    break;
                }
                case And: {
                    this.code.ifeq(end);
                }
            }
            this.code.pop();
            this.visit(node.values[i]);
        }
        this.code.label(end);
        return null;
    }

    public Object visitCompare(Compare node) throws Exception {
        int last = this.code.getLocal("org/python/core/PyObject");
        int result = this.code.getLocal("org/python/core/PyObject");
        Label end = new Label();
        this.visit(node.left);
        this.code.astore(last);
        int n = node.ops.length;
        for (int i = 0; i < n - 1; ++i) {
            this.visit(node.comparators[i]);
            this.code.aload(last);
            this.code.swap();
            this.code.dup();
            this.code.astore(last);
            this.visitCmpop(node.ops[i]);
            this.code.dup();
            this.code.astore(result);
            this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
            this.code.ifeq(end);
        }
        this.visit(node.comparators[n - 1]);
        this.code.aload(last);
        this.code.swap();
        this.visitCmpop(node.ops[n - 1]);
        if (n > 1) {
            this.code.astore(result);
            this.code.label(end);
            this.code.aload(result);
        }
        this.code.aconst_null();
        this.code.astore(last);
        this.code.freeLocal(last);
        this.code.freeLocal(result);
        return null;
    }

    public void visitCmpop(cmpopType op) throws Exception {
        String name = null;
        switch (op) {
            case Eq: {
                name = "_eq";
                break;
            }
            case NotEq: {
                name = "_ne";
                break;
            }
            case Lt: {
                name = "_lt";
                break;
            }
            case LtE: {
                name = "_le";
                break;
            }
            case Gt: {
                name = "_gt";
                break;
            }
            case GtE: {
                name = "_ge";
                break;
            }
            case Is: {
                name = "_is";
                break;
            }
            case IsNot: {
                name = "_isnot";
                break;
            }
            case In: {
                name = "_in";
                break;
            }
            case NotIn: {
                name = "_notin";
            }
        }
        this.code.invokevirtual("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
    }

    public Object visitBinOp(BinOp node) throws Exception {
        this.visit(node.left);
        this.stackProduce();
        this.visit(node.right);
        this.stackConsume();
        String name = null;
        switch (node.op) {
            case Add: {
                name = "_add";
                break;
            }
            case Sub: {
                name = "_sub";
                break;
            }
            case Mult: {
                name = "_mul";
                break;
            }
            case Div: {
                name = "_div";
                break;
            }
            case Mod: {
                name = "_mod";
                break;
            }
            case Pow: {
                name = "_pow";
                break;
            }
            case LShift: {
                name = "_lshift";
                break;
            }
            case RShift: {
                name = "_rshift";
                break;
            }
            case BitOr: {
                name = "_or";
                break;
            }
            case BitXor: {
                name = "_xor";
                break;
            }
            case BitAnd: {
                name = "_and";
                break;
            }
            case FloorDiv: {
                name = "_floordiv";
            }
        }
        if (node.op == operatorType.Div && this.module.getFutures().areDivisionOn()) {
            name = "_truediv";
        }
        this.code.invokevirtual("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        return null;
    }

    public Object visitUnaryOp(UnaryOp node) throws Exception {
        this.visit(node.operand);
        String name = null;
        switch (node.op) {
            case Invert: {
                name = "__invert__";
                break;
            }
            case Not: {
                name = "__not__";
                break;
            }
            case UAdd: {
                name = "__pos__";
                break;
            }
            case USub: {
                name = "__neg__";
            }
        }
        this.code.invokevirtual("org/python/core/PyObject", name, "()Lorg/python/core/PyObject;");
        return null;
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        this.setline(node);
        this.augmode = expr_contextType.Load;
        this.visit(node.target);
        int target = this.storeTop();
        this.visit(node.value);
        this.code.aload(target);
        this.code.swap();
        String name = null;
        switch (node.op) {
            case Add: {
                name = "_iadd";
                break;
            }
            case Sub: {
                name = "_isub";
                break;
            }
            case Mult: {
                name = "_imul";
                break;
            }
            case Div: {
                name = "_idiv";
                break;
            }
            case Mod: {
                name = "_imod";
                break;
            }
            case Pow: {
                name = "_ipow";
                break;
            }
            case LShift: {
                name = "_ilshift";
                break;
            }
            case RShift: {
                name = "_irshift";
                break;
            }
            case BitOr: {
                name = "_ior";
                break;
            }
            case BitXor: {
                name = "_ixor";
                break;
            }
            case BitAnd: {
                name = "_iand";
                break;
            }
            case FloorDiv: {
                name = "_ifloordiv";
            }
        }
        if (node.op == operatorType.Div && this.module.getFutures().areDivisionOn()) {
            name = "_itruediv";
        }
        this.code.invokevirtual("org/python/core/PyObject", name, "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        this.code.freeLocal(target);
        this.temporary = this.storeTop();
        this.augmode = expr_contextType.Store;
        this.visit(node.target);
        this.code.freeLocal(this.temporary);
        return null;
    }

    public static int makeStrings(Code c, String[] names, int n) throws IOException {
        c.iconst(n);
        c.anewarray("java/lang/String");
        int strings = c.getLocal("[Ljava/lang/String;");
        c.astore(strings);
        for (int i = 0; i < n; ++i) {
            c.aload(strings);
            c.iconst(i);
            c.ldc(names[i]);
            c.aastore();
        }
        return strings;
    }

    public Object invokeNoKeywords(Attribute node, PythonTree[] values) throws Exception {
        String name = this.getName(node.attr);
        this.visit(node.value);
        this.stackProduce();
        this.code.ldc(name);
        this.code.invokevirtual("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        switch (values.length) {
            case 0: {
                this.stackConsume();
                this.code.invokevirtual("org/python/core/PyObject", "__call__", "()Lorg/python/core/PyObject;");
                break;
            }
            case 1: {
                this.visit(values[0]);
                this.stackConsume();
                this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                break;
            }
            case 2: {
                this.visit(values[0]);
                this.stackProduce();
                this.visit(values[1]);
                this.stackConsume(2);
                this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                break;
            }
            case 3: {
                this.visit(values[0]);
                this.stackProduce();
                this.visit(values[1]);
                this.stackProduce();
                this.visit(values[2]);
                this.stackConsume(3);
                this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                break;
            }
            case 4: {
                this.visit(values[0]);
                this.stackProduce();
                this.visit(values[1]);
                this.stackProduce();
                this.visit(values[2]);
                this.stackProduce();
                this.visit(values[3]);
                this.stackConsume(4);
                this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                break;
            }
            default: {
                int argArray = this.makeArray(values);
                this.code.aload(argArray);
                this.code.freeLocal(argArray);
                this.stackConsume();
                this.code.invokevirtual("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
            }
        }
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        int argArray;
        int i;
        String[] keys = new String[node.keywords.length];
        PythonTree[] values = new exprType[node.args.length + keys.length];
        for (i = 0; i < node.args.length; ++i) {
            values[i] = node.args[i];
        }
        for (i = 0; i < node.keywords.length; ++i) {
            keys[i] = node.keywords[i].arg;
            values[node.args.length + i] = node.keywords[i].value;
        }
        if ((node.keywords == null || node.keywords.length == 0) && node.starargs == null && node.kwargs == null && node.func instanceof Attribute) {
            return this.invokeNoKeywords((Attribute)node.func, values);
        }
        this.visit(node.func);
        this.stackProduce();
        if (node.starargs != null || node.kwargs != null) {
            argArray = this.makeArray(values);
            int strArray = CodeCompiler.makeStrings(this.code, keys, keys.length);
            if (node.starargs == null) {
                this.code.aconst_null();
            } else {
                this.visit(node.starargs);
            }
            this.stackProduce();
            if (node.kwargs == null) {
                this.code.aconst_null();
            } else {
                this.visit(node.kwargs);
            }
            this.stackProduce();
            this.code.aload(argArray);
            this.code.aload(strArray);
            this.code.freeLocal(argArray);
            this.code.freeLocal(strArray);
            this.code.dup2_x2();
            this.code.pop2();
            this.stackConsume(3);
            this.code.invokevirtual("org/python/core/PyObject", "_callextra", "([Lorg/python/core/PyObject;[Ljava/lang/String;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        } else if (keys.length > 0) {
            argArray = this.makeArray(values);
            int strArray = CodeCompiler.makeStrings(this.code, keys, keys.length);
            this.code.aload(argArray);
            this.code.aload(strArray);
            this.code.freeLocal(argArray);
            this.code.freeLocal(strArray);
            this.stackConsume();
            this.code.invokevirtual("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;[Ljava/lang/String;)Lorg/python/core/PyObject;");
        } else {
            switch (values.length) {
                case 0: {
                    this.stackConsume();
                    this.code.invokevirtual("org/python/core/PyObject", "__call__", "()Lorg/python/core/PyObject;");
                    break;
                }
                case 1: {
                    this.visit(values[0]);
                    this.stackConsume();
                    this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    break;
                }
                case 2: {
                    this.visit(values[0]);
                    this.stackProduce();
                    this.visit(values[1]);
                    this.stackConsume(2);
                    this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    break;
                }
                case 3: {
                    this.visit(values[0]);
                    this.stackProduce();
                    this.visit(values[1]);
                    this.stackProduce();
                    this.visit(values[2]);
                    this.stackConsume(3);
                    this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    break;
                }
                case 4: {
                    this.visit(values[0]);
                    this.stackProduce();
                    this.visit(values[1]);
                    this.stackProduce();
                    this.visit(values[2]);
                    this.stackProduce();
                    this.visit(values[3]);
                    this.stackConsume(4);
                    this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                    break;
                }
                default: {
                    argArray = this.makeArray(values);
                    this.code.aload(argArray);
                    this.code.freeLocal(argArray);
                    this.stackConsume();
                    this.code.invokevirtual("org/python/core/PyObject", "__call__", "([Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                }
            }
        }
        return null;
    }

    public Object Slice(Subscript node, Slice slice) throws Exception {
        expr_contextType ctx = node.ctx;
        if (ctx == expr_contextType.AugStore && this.augmode == expr_contextType.Store) {
            this.restoreAugTmps(node, 4);
            ctx = expr_contextType.Store;
        } else {
            this.visit(node.value);
            this.stackProduce();
            if (slice.lower != null) {
                this.visit(slice.lower);
            } else {
                this.code.aconst_null();
            }
            this.stackProduce();
            if (slice.upper != null) {
                this.visit(slice.upper);
            } else {
                this.code.aconst_null();
            }
            this.stackProduce();
            if (slice.step != null) {
                this.visit(slice.step);
            } else {
                this.code.aconst_null();
            }
            this.stackProduce();
            if (node.ctx == expr_contextType.AugStore && this.augmode == expr_contextType.Load) {
                this.saveAugTmps(node, 4);
                ctx = expr_contextType.Load;
            }
        }
        this.stackConsume(4);
        switch (ctx) {
            case Del: {
                this.code.invokevirtual("org/python/core/PyObject", "__delslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                return null;
            }
            case Load: {
                this.code.invokevirtual("org/python/core/PyObject", "__getslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                return null;
            }
            case Param: 
            case Store: {
                this.code.aload(this.temporary);
                this.code.invokevirtual("org/python/core/PyObject", "__setslice__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                return null;
            }
        }
        return null;
    }

    public Object visitSubscript(Subscript node) throws Exception {
        if (node.slice instanceof Slice) {
            return this.Slice(node, (Slice)node.slice);
        }
        int value = this.temporary;
        expr_contextType ctx = node.ctx;
        if (node.ctx == expr_contextType.AugStore && this.augmode == expr_contextType.Store) {
            this.restoreAugTmps(node, 2);
            ctx = expr_contextType.Store;
        } else {
            this.visit(node.value);
            this.stackProduce();
            this.visit(node.slice);
            if (node.ctx == expr_contextType.AugStore && this.augmode == expr_contextType.Load) {
                this.saveAugTmps(node, 2);
                ctx = expr_contextType.Load;
            }
        }
        this.stackConsume();
        switch (ctx) {
            case Del: {
                this.code.invokevirtual("org/python/core/PyObject", "__delitem__", "(Lorg/python/core/PyObject;)V");
                return null;
            }
            case Load: {
                this.code.invokevirtual("org/python/core/PyObject", "__getitem__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
                return null;
            }
            case Param: 
            case Store: {
                this.code.aload(value);
                this.code.invokevirtual("org/python/core/PyObject", "__setitem__", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
                return null;
            }
        }
        return null;
    }

    public Object visitIndex(Index node) throws Exception {
        this.traverse(node);
        return null;
    }

    public Object visitExtSlice(ExtSlice node) throws Exception {
        int dims = this.makeArray(node.dims);
        this.code.new_("org/python/core/PyTuple");
        this.code.dup();
        this.code.aload(dims);
        this.code.freeLocal(dims);
        this.code.invokespecial("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        expr_contextType ctx = node.ctx;
        if (node.ctx == expr_contextType.AugStore && this.augmode == expr_contextType.Store) {
            this.restoreAugTmps(node, 2);
            ctx = expr_contextType.Store;
        } else {
            this.visit(node.value);
            this.code.ldc(this.getName(node.attr));
            if (node.ctx == expr_contextType.AugStore && this.augmode == expr_contextType.Load) {
                this.saveAugTmps(node, 2);
                ctx = expr_contextType.Load;
            }
        }
        switch (ctx) {
            case Del: {
                this.code.invokevirtual("org/python/core/PyObject", "__delattr__", "(Ljava/lang/String;)V");
                return null;
            }
            case Load: {
                this.code.invokevirtual("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                return null;
            }
            case Param: 
            case Store: {
                this.code.aload(this.temporary);
                this.code.invokevirtual("org/python/core/PyObject", "__setattr__", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                return null;
            }
        }
        return null;
    }

    public Object seqSet(exprType[] nodes) throws Exception {
        this.code.aload(this.temporary);
        this.code.iconst(nodes.length);
        this.code.invokestatic("org/python/core/Py", "unpackSequence", "(Lorg/python/core/PyObject;I)[Lorg/python/core/PyObject;");
        int tmp = this.code.getLocal("[org/python/core/PyObject");
        this.code.astore(tmp);
        for (int i = 0; i < nodes.length; ++i) {
            this.code.aload(tmp);
            this.code.iconst(i);
            this.code.aaload();
            this.set(nodes[i]);
        }
        this.code.freeLocal(tmp);
        return null;
    }

    public Object seqDel(exprType[] nodes) throws Exception {
        for (int i = 0; i < nodes.length; ++i) {
            this.visit(nodes[i]);
        }
        return null;
    }

    public Object visitTuple(Tuple node) throws Exception {
        if (node.ctx == expr_contextType.Store) {
            return this.seqSet(node.elts);
        }
        if (node.ctx == expr_contextType.Del) {
            return this.seqDel(node.elts);
        }
        int content = this.makeArray(node.elts);
        this.code.new_("org/python/core/PyTuple");
        this.code.dup();
        this.code.aload(content);
        this.code.freeLocal(content);
        this.code.invokespecial("org/python/core/PyTuple", "<init>", "([Lorg/python/core/PyObject;)V");
        return null;
    }

    public Object visitList(List node) throws Exception {
        if (node.ctx == expr_contextType.Store) {
            return this.seqSet(node.elts);
        }
        if (node.ctx == expr_contextType.Del) {
            return this.seqDel(node.elts);
        }
        int content = this.makeArray(node.elts);
        this.code.new_("org/python/core/PyList");
        this.code.dup();
        this.code.aload(content);
        this.code.freeLocal(content);
        this.code.invokespecial("org/python/core/PyList", "<init>", "([Lorg/python/core/PyObject;)V");
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.code.new_("org/python/core/PyList");
        this.code.dup();
        this.code.invokespecial("org/python/core/PyList", "<init>", "()V");
        this.code.dup();
        this.code.ldc("append");
        this.code.invokevirtual("org/python/core/PyObject", "__getattr__", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
        String tmp_append = "_[" + node.getLine() + "_" + node.getCharPositionInLine() + "]";
        this.set(new Name(node, tmp_append, expr_contextType.Store));
        stmtType n = new Expr(node, (exprType)new Call(node, (exprType)new Name(node, tmp_append, expr_contextType.Load), new exprType[]{node.elt}, new keywordType[0], null, null));
        for (int i = node.generators.length - 1; i >= 0; --i) {
            comprehensionType lc = node.generators[i];
            for (int j = lc.ifs.length - 1; j >= 0; --j) {
                n = new If(lc.ifs[j], lc.ifs[j], new stmtType[]{n}, new stmtType[0]);
            }
            n = new For(lc, lc.target, lc.iter, new stmtType[]{n}, new stmtType[0]);
        }
        this.visit(n);
        this.visit(new Delete(n, new exprType[]{new Name(n, tmp_append, expr_contextType.Del)}));
        return null;
    }

    public Object visitDict(Dict node) throws Exception {
        PythonTree[] elts = new PythonTree[node.keys.length * 2];
        for (int i = 0; i < node.keys.length; ++i) {
            elts[i * 2] = node.keys[i];
            elts[i * 2 + 1] = node.values[i];
        }
        int content = this.makeArray(elts);
        this.code.new_("org/python/core/PyDictionary");
        this.code.dup();
        this.code.aload(content);
        this.code.freeLocal(content);
        this.code.invokespecial("org/python/core/PyDictionary", "<init>", "([Lorg/python/core/PyObject;)V");
        return null;
    }

    public Object visitRepr(Repr node) throws Exception {
        this.visit(node.value);
        this.code.invokevirtual("org/python/core/PyObject", "__repr__", "()Lorg/python/core/PyString;");
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        String name = "<lambda>";
        Suite retSuite = new Suite(node, new stmtType[]{new Return(node, node.body)});
        this.setline(node);
        ScopeInfo scope = this.module.getScopeInfo(node);
        int defaultsArray = this.makeArray(scope.ac.getDefaults());
        this.code.new_("org/python/core/PyFunction");
        this.code.dup();
        this.code.aload(defaultsArray);
        this.code.freeLocal(defaultsArray);
        this.loadFrame();
        this.code.getfield("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        this.code.swap();
        scope.setup_closure();
        scope.dump();
        this.module.PyCode(retSuite, name, true, this.className, false, false, node.getLine(), scope, this.cflags).get(this.code);
        if (!this.makeClosure(scope)) {
            this.code.invokespecial("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;)V");
        } else {
            this.code.invokespecial("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;[Lorg/python/core/PyObject;)V");
        }
        return null;
    }

    public Object visitEllipsis(Ellipsis node) throws Exception {
        this.code.getstatic("org/python/core/Py", "Ellipsis", "Lorg/python/core/PyObject;");
        return null;
    }

    public Object visitSlice(Slice node) throws Exception {
        if (node.lower == null) {
            this.getNone();
        } else {
            this.visit(node.lower);
        }
        this.stackProduce();
        if (node.upper == null) {
            this.getNone();
        } else {
            this.visit(node.upper);
        }
        this.stackProduce();
        if (node.step == null) {
            this.getNone();
        } else {
            this.visit(node.step);
        }
        int step = this.storeTop();
        this.stackConsume(2);
        this.code.new_("org/python/core/PySlice");
        this.code.dup();
        this.code.dup2_x2();
        this.code.pop2();
        this.code.aload(step);
        this.code.freeLocal(step);
        this.code.invokespecial("org/python/core/PySlice", "<init>", "(Lorg/python/core/PyObject;Lorg/python/core/PyObject;Lorg/python/core/PyObject;)V");
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        this.setline(node);
        int baseArray = this.makeArray(node.bases);
        String name = this.getName(node.name);
        this.code.ldc(name);
        this.code.aload(baseArray);
        this.code.freeLocal(baseArray);
        ScopeInfo scope = this.module.getScopeInfo(node);
        scope.setup_closure();
        scope.dump();
        this.module.PyCode(new Suite(node, node.body), name, false, name, true, false, node.getLine(), scope, this.cflags).get(this.code);
        this.getDocString(node.body);
        if (!this.makeClosure(scope)) {
            this.code.invokestatic("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        } else {
            this.code.invokestatic("org/python/core/Py", "makeClass", "(Ljava/lang/String;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        }
        this.set(new Name(node, node.name, expr_contextType.Store));
        this.doDecorators(node, node.decorators, node.name);
        return null;
    }

    public Object visitNum(Num node) throws Exception {
        if (node.n instanceof PyInteger) {
            this.module.PyInteger(((PyInteger)node.n).getValue()).get(this.code);
        } else if (node.n instanceof PyLong) {
            this.module.PyLong(((PyObject)node.n).__str__().toString()).get(this.code);
        } else if (node.n instanceof PyFloat) {
            this.module.PyFloat(((PyFloat)node.n).getValue()).get(this.code);
        } else if (node.n instanceof PyComplex) {
            this.module.PyComplex(((PyComplex)node.n).imag).get(this.code);
        }
        return null;
    }

    private String getName(String name) {
        if (this.className != null && name.startsWith("__") && !name.endsWith("__")) {
            int i = 0;
            while (this.className.charAt(i) == '_') {
                ++i;
            }
            return "_" + this.className.substring(i) + name;
        }
        return name;
    }

    void emitGetGlobal(String name) throws Exception {
        this.code.ldc(name);
        this.code.invokevirtual("org/python/core/PyFrame", "getglobal", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
    }

    public Object visitName(Name node) throws Exception {
        String name = this.fast_locals ? node.id : this.getName(node.id);
        SymInfo syminf = this.tbl.get(name);
        expr_contextType ctx = node.ctx;
        if (ctx == expr_contextType.AugStore) {
            ctx = this.augmode;
        }
        switch (ctx) {
            case Load: {
                this.loadFrame();
                if (syminf != null) {
                    int flags = syminf.flags;
                    if ((flags & 0x42) != 0 || this.optimizeGlobals && (flags & 0x31) == 0) {
                        this.emitGetGlobal(name);
                        return null;
                    }
                    if (this.fast_locals) {
                        if ((flags & 0x10) != 0) {
                            this.code.iconst(syminf.env_index);
                            this.code.invokevirtual("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                            return null;
                        }
                        if ((flags & 1) != 0) {
                            this.code.iconst(syminf.locals_index);
                            this.code.invokevirtual("org/python/core/PyFrame", "getlocal", "(I)Lorg/python/core/PyObject;");
                            return null;
                        }
                    }
                    if ((flags & 0x20) != 0 && (flags & 1) == 0) {
                        this.code.iconst(syminf.env_index);
                        this.code.invokevirtual("org/python/core/PyFrame", "getderef", "(I)Lorg/python/core/PyObject;");
                        return null;
                    }
                }
                this.code.ldc(name);
                this.code.invokevirtual("org/python/core/PyFrame", "getname", "(Ljava/lang/String;)Lorg/python/core/PyObject;");
                return null;
            }
            case Param: 
            case Store: {
                this.loadFrame();
                if (syminf != null && (syminf.flags & 0x42) != 0) {
                    this.code.ldc(name);
                    this.code.aload(this.temporary);
                    this.code.invokevirtual("org/python/core/PyFrame", "setglobal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                } else if (!this.fast_locals) {
                    this.code.ldc(name);
                    this.code.aload(this.temporary);
                    this.code.invokevirtual("org/python/core/PyFrame", "setlocal", "(Ljava/lang/String;Lorg/python/core/PyObject;)V");
                } else {
                    if (syminf == null) {
                        throw new ParseException("internal compiler error", node);
                    }
                    if ((syminf.flags & 0x10) != 0) {
                        this.code.iconst(syminf.env_index);
                        this.code.aload(this.temporary);
                        this.code.invokevirtual("org/python/core/PyFrame", "setderef", "(ILorg/python/core/PyObject;)V");
                    } else {
                        this.code.iconst(syminf.locals_index);
                        this.code.aload(this.temporary);
                        this.code.invokevirtual("org/python/core/PyFrame", "setlocal", "(ILorg/python/core/PyObject;)V");
                    }
                }
                return null;
            }
            case Del: {
                this.loadFrame();
                if (syminf != null && (syminf.flags & 0x42) != 0) {
                    this.code.ldc(name);
                    this.code.invokevirtual("org/python/core/PyFrame", "delglobal", "(Ljava/lang/String;)V");
                } else if (!this.fast_locals) {
                    this.code.ldc(name);
                    this.code.invokevirtual("org/python/core/PyFrame", "dellocal", "(Ljava/lang/String;)V");
                } else {
                    if (syminf == null) {
                        throw new ParseException("internal compiler error", node);
                    }
                    if ((syminf.flags & 0x10) != 0) {
                        this.module.error("can not delete variable '" + name + "' referenced in nested scope", true, node);
                    }
                    this.code.iconst(syminf.locals_index);
                    this.code.invokevirtual("org/python/core/PyFrame", "dellocal", "(I)V");
                }
                return null;
            }
        }
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        PyString s = (PyString)node.s;
        if (s instanceof PyUnicode) {
            this.module.PyUnicode(s.asString()).get(this.code);
        } else {
            this.module.PyString(s.asString()).get(this.code);
        }
        return null;
    }

    public Object visitGeneratorExp(GeneratorExp node) throws Exception {
        String bound_exp = "_(x)";
        String tmp_append = "_(" + node.getLine() + "_" + node.getCharPositionInLine() + ")";
        this.setline(node);
        this.code.new_("org/python/core/PyFunction");
        this.code.dup();
        this.loadFrame();
        this.code.getfield("org/python/core/PyFrame", "f_globals", "Lorg/python/core/PyObject;");
        ScopeInfo scope = this.module.getScopeInfo(node);
        int emptyArray = this.makeArray(new exprType[0]);
        this.code.aload(emptyArray);
        this.code.freeLocal(emptyArray);
        scope.setup_closure();
        scope.dump();
        stmtType n = new Expr(node, (exprType)new Yield(node, node.elt));
        exprType iter = null;
        for (int i = node.generators.length - 1; i >= 0; --i) {
            comprehensionType comp = node.generators[i];
            for (int j = comp.ifs.length - 1; j >= 0; --j) {
                n = new If(comp.ifs[j], comp.ifs[j], new stmtType[]{n}, new stmtType[0]);
            }
            if (i != 0) {
                n = new For(comp, comp.target, comp.iter, new stmtType[]{n}, new stmtType[0]);
                continue;
            }
            n = new For(comp, comp.target, (exprType)new Name(node, bound_exp, expr_contextType.Load), new stmtType[]{n}, new stmtType[0]);
            iter = comp.iter;
        }
        this.module.PyCode(new Suite(node, new stmtType[]{n}), tmp_append, true, this.className, false, false, node.getLine(), scope, this.cflags).get(this.code);
        this.code.aconst_null();
        if (!this.makeClosure(scope)) {
            this.code.invokespecial("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;)V");
        } else {
            this.code.invokespecial("org/python/core/PyFunction", "<init>", "(Lorg/python/core/PyObject;[Lorg/python/core/PyObject;Lorg/python/core/PyCode;Lorg/python/core/PyObject;[Lorg/python/core/PyObject;)V");
        }
        this.set(new Name(node, tmp_append, expr_contextType.Store));
        this.visit(iter);
        this.visit(new Name(node, tmp_append, expr_contextType.Load));
        this.code.swap();
        this.code.invokevirtual("org/python/core/PyObject", "__iter__", "()Lorg/python/core/PyObject;");
        this.code.invokevirtual("org/python/core/PyObject", "__call__", "(Lorg/python/core/PyObject;)Lorg/python/core/PyObject;");
        this.visit(new Delete(n, new exprType[]{new Name(n, tmp_append, expr_contextType.Del)}));
        return null;
    }

    public Object visitWith(With node) throws Exception {
        if (!this.module.getFutures().withStatementSupported()) {
            throw new ParseException("'with' will become a reserved keyword in Python 2.6", node);
        }
        Label label_body_start = new Label();
        Label label_body_end = new Label();
        Label label_catch = new Label();
        Label label_finally = new Label();
        Label label_end = new Label();
        Method getattr = Method.getMethod("org.python.core.PyObject __getattr__ (String)");
        Method call = Method.getMethod("org.python.core.PyObject __call__ ()");
        Method call3 = Method.getMethod("org.python.core.PyObject __call__ (org.python.core.PyObject,org.python.core.PyObject,org.python.core.PyObject)");
        this.visit(node.context_expr);
        this.code.dup();
        this.code.ldc("__exit__");
        this.code.invokevirtual(Type.getType(PyObject.class).getInternalName(), getattr.getName(), getattr.getDescriptor());
        int __exit__ = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(__exit__);
        this.code.ldc("__enter__");
        this.code.invokevirtual(Type.getType(PyObject.class).getInternalName(), getattr.getName(), getattr.getDescriptor());
        this.code.invokevirtual(Type.getType(PyObject.class).getInternalName(), call.getName(), call.getDescriptor());
        int value_tmp = this.code.getLocal("org/python/core/PyObject");
        this.code.astore(value_tmp);
        ExceptionHandler handler = new ExceptionHandler();
        handler.exceptionStarts.addElement(label_body_start);
        this.exceptionHandlers.push(handler);
        this.code.label(label_body_start);
        if (node.optional_vars != null) {
            this.set(node.optional_vars, value_tmp);
        }
        this.code.freeLocal(value_tmp);
        this.suite(node.body);
        this.exceptionHandlers.pop();
        this.code.goto_(label_finally);
        this.code.label(label_body_end);
        handler.exceptionEnds.addElement(label_body_end);
        this.code.label(label_catch);
        this.loadFrame();
        this.code.invokestatic("org/python/core/Py", "setException", "(Ljava/lang/Throwable;Lorg/python/core/PyFrame;)Lorg/python/core/PyException;");
        this.code.pop();
        this.code.invokestatic("org/python/core/Py", "getThreadState", "()Lorg/python/core/ThreadState;");
        this.code.getfield("org/python/core/ThreadState", "exception", "Lorg/python/core/PyException;");
        int ts_tmp = this.storeTop();
        this.code.aload(__exit__);
        this.code.aload(ts_tmp);
        this.code.getfield("org/python/core/PyException", "type", "Lorg/python/core/PyObject;");
        this.code.aload(ts_tmp);
        this.code.getfield("org/python/core/PyException", "value", "Lorg/python/core/PyObject;");
        this.code.aload(ts_tmp);
        this.code.getfield("org/python/core/PyException", "traceback", "Lorg/python/core/PyTraceback;");
        this.code.checkcast("org/python/core/PyObject");
        this.code.invokevirtual(Type.getType(PyObject.class).getInternalName(), call3.getName(), call3.getDescriptor());
        this.code.invokevirtual("org/python/core/PyObject", "__nonzero__", "()Z");
        this.code.ifne(label_end);
        this.code.invokestatic("org/python/core/Py", "makeException", "()Lorg/python/core/PyException;");
        this.code.checkcast("java/lang/Throwable");
        this.code.athrow();
        this.code.freeLocal(ts_tmp);
        handler.addExceptionHandlers(label_catch);
        this.code.label(label_finally);
        this.code.aload(__exit__);
        this.getNone();
        this.code.dup();
        this.code.dup();
        this.code.invokevirtual(Type.getType(PyObject.class).getInternalName(), call3.getName(), call3.getDescriptor());
        this.code.pop();
        this.code.label(label_end);
        this.code.freeLocal(__exit__);
        return null;
    }

    protected Object unhandled_node(PythonTree node) throws Exception {
        throw new Exception("Unhandled node " + node);
    }

    class ExceptionHandler {
        public Vector exceptionStarts = new Vector();
        public Vector exceptionEnds = new Vector();
        public boolean bodyDone = false;
        public PythonTree node = null;

        public ExceptionHandler() {
        }

        public ExceptionHandler(PythonTree n) {
            this.node = n;
        }

        public boolean isFinallyHandler() {
            return this.node != null;
        }

        public void addExceptionHandlers(Label handlerStart) throws Exception {
            for (int i = 0; i < this.exceptionStarts.size(); ++i) {
                Label start = (Label)this.exceptionStarts.elementAt(i);
                Label end = (Label)this.exceptionEnds.elementAt(i);
                if (start.getOffset() == end.getOffset()) continue;
                CodeCompiler.this.code.trycatch((Label)this.exceptionStarts.elementAt(i), (Label)this.exceptionEnds.elementAt(i), handlerStart, "java/lang/Throwable");
            }
        }
    }
}

