/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import org.antlr.analysis.SemanticContext;
import org.antlr.misc.IntSet;
import org.antlr.misc.IntervalSet;
import org.antlr.tool.Grammar;

public class Label
implements Comparable,
Cloneable {
    public static final int INVALID = -7;
    public static final int ACTION = -6;
    public static final int EPSILON = -5;
    public static final String EPSILON_STR = "<EPSILON>";
    public static final int SEMPRED = -4;
    public static final int SET = -3;
    public static final int EOT = -2;
    public static final int EOF = -1;
    public static final int NUM_FAUX_LABELS = 7;
    public static final int MIN_ATOM_VALUE = -2;
    public static final int MIN_CHAR_VALUE = 0;
    public static final int MAX_CHAR_VALUE = 65534;
    public static final int EOR_TOKEN_TYPE = 1;
    public static final int DOWN = 2;
    public static final int UP = 3;
    public static final int MIN_TOKEN_TYPE = 4;
    protected int label;
    protected IntSet labelSet;

    public Label(int n) {
        this.label = n;
    }

    public Label(IntSet intSet) {
        if (intSet == null) {
            this.label = -3;
            this.labelSet = IntervalSet.of(-7);
            return;
        }
        int n = intSet.getSingleElement();
        if (n != -7) {
            this.label = n;
            return;
        }
        this.label = -3;
        this.labelSet = intSet;
    }

    public Object clone() {
        Label label;
        try {
            label = (Label)super.clone();
            label.label = this.label;
            label.labelSet = new IntervalSet();
            label.labelSet.addAll(this.labelSet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return label;
    }

    public void add(Label label) {
        if (this.isAtom()) {
            this.labelSet = IntervalSet.of(this.label);
            this.label = -3;
            if (label.isAtom()) {
                this.labelSet.add(label.getAtom());
            } else if (label.isSet()) {
                this.labelSet.addAll(label.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        if (this.isSet()) {
            if (label.isAtom()) {
                this.labelSet.add(label.getAtom());
            } else if (label.isSet()) {
                this.labelSet.addAll(label.getSet());
            } else {
                throw new IllegalStateException("can't add element to Label of type " + this.label);
            }
            return;
        }
        throw new IllegalStateException("can't add element to Label of type " + this.label);
    }

    public boolean isAtom() {
        return this.label >= -2;
    }

    public boolean isEpsilon() {
        return this.label == -5;
    }

    public boolean isSemanticPredicate() {
        return false;
    }

    public boolean isAction() {
        return false;
    }

    public boolean isSet() {
        return this.label == -3;
    }

    public int getAtom() {
        if (this.isAtom()) {
            return this.label;
        }
        return -7;
    }

    public IntSet getSet() {
        if (this.label != -3) {
            return IntervalSet.of(this.label);
        }
        return this.labelSet;
    }

    public void setSet(IntSet intSet) {
        this.label = -3;
        this.labelSet = intSet;
    }

    public SemanticContext getSemanticContext() {
        return null;
    }

    public boolean matches(int n) {
        if (this.label == n) {
            return true;
        }
        if (this.isSet()) {
            return this.labelSet.member(n);
        }
        return false;
    }

    public boolean matches(IntSet intSet) {
        if (this.isAtom()) {
            return intSet.member(this.getAtom());
        }
        if (this.isSet()) {
            return !this.getSet().and(intSet).isNil();
        }
        return false;
    }

    public boolean matches(Label label) {
        if (label.isSet()) {
            return this.matches(label.getSet());
        }
        if (label.isAtom()) {
            return this.matches(label.getAtom());
        }
        return false;
    }

    public int hashCode() {
        if (this.label == -3) {
            return this.labelSet.hashCode();
        }
        return this.label;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.label != ((Label)object).label) {
            return false;
        }
        if (this.label == -3) {
            return ((Object)this.labelSet).equals(((Label)object).labelSet);
        }
        return true;
    }

    public int compareTo(Object object) {
        return this.label - ((Label)object).label;
    }

    public String toString() {
        switch (this.label) {
            case -3: {
                return ((Object)this.labelSet).toString();
            }
        }
        return String.valueOf(this.label);
    }

    public String toString(Grammar grammar) {
        switch (this.label) {
            case -3: {
                return this.labelSet.toString(grammar);
            }
        }
        return grammar.getTokenDisplayName(this.label);
    }

    public static boolean intersect(Label label, Label label2) {
        boolean bl = false;
        boolean bl2 = label.isSet();
        boolean bl3 = label2.isSet();
        if (!bl2 && !bl3 && label2.label == label.label) {
            bl = true;
        } else if (bl2 && bl3 && !label2.getSet().and(label.getSet()).isNil()) {
            bl = true;
        } else if (bl2 && !bl3 && label.getSet().member(label2.label)) {
            bl = true;
        } else if (!bl2 && bl3 && label2.getSet().member(label.label)) {
            bl = true;
        }
        return bl;
    }
}

