/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.InputStream;
import java.util.ArrayList;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotify;
import org.tigris.subversion.svnclientadapter.commandline.CommandLine;
import org.tigris.subversion.svnclientadapter.commandline.parser.SvnOutputParser;

public class SvnCommandLine
extends CommandLine {
    private String user;
    private String pass;
    protected SvnOutputParser svnOutputParser = new SvnOutputParser();
    protected long rev = -1L;
    protected boolean parseSvnOutput = false;
    private String configDir = null;

    SvnCommandLine(String string, CmdLineNotificationHandler cmdLineNotificationHandler) {
        super(string, cmdLineNotificationHandler);
    }

    protected static String validRev(String string) {
        return string == null || "".equals(string) ? "HEAD" : string;
    }

    void setUsername(String string) {
        this.user = string;
    }

    void setPassword(String string) {
        this.pass = string;
    }

    void setConfigDirectory(String string) {
        this.configDir = string;
    }

    String version() throws CmdLineException {
        this.setCommand(0, false);
        return super.version();
    }

    String add(String string, boolean bl) throws CmdLineException {
        this.setCommand(1, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("add");
        if (!bl) {
            arrayList.add("-N");
        }
        arrayList.add(string);
        return this.execString(arrayList, false);
    }

    protected ArrayList addAuthInfo(ArrayList arrayList) {
        if (this.user != null && this.user.length() > 0) {
            arrayList.add("--username");
            arrayList.add(this.user);
        }
        if (this.pass != null && this.pass.length() > 0) {
            arrayList.add("--password");
            arrayList.add(this.pass);
        }
        arrayList.add("--non-interactive");
        return arrayList;
    }

    protected ArrayList addConfigInfo(ArrayList arrayList) {
        if (this.configDir != null) {
            arrayList.add("--config-dir");
            arrayList.add(this.configDir);
        }
        return arrayList;
    }

    InputStream cat(String string, String string2) throws CmdLineException {
        this.setCommand(18, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cat");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string2));
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        Process process = this.execProcess(arrayList);
        return process.getInputStream();
    }

    String checkin(String[] stringArray, String string, boolean bl) throws CmdLineException {
        this.setCommand(3, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ci");
        if (bl) {
            arrayList.add("--no-unlock");
        }
        arrayList.add("--force-log");
        arrayList.add("-m");
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return this.execString(arrayList, false);
    }

    void cleanup(String string) throws CmdLineException {
        this.setCommand(24, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cleanup");
        arrayList.add(string);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String checkout(String string, String string2, String string3, boolean bl) throws CmdLineException {
        this.setCommand(2, true);
        String string4 = SvnCommandLine.validRev(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("co");
        arrayList.add("-r");
        arrayList.add(string4);
        arrayList.add(string + "@" + string4);
        arrayList.add(string2);
        if (!bl) {
            arrayList.add("-N");
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    void copy(String string, String string2, String string3, String string4) throws CmdLineException {
        this.setCommand(6, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cp");
        if (string4 != null) {
            arrayList.add("-r");
            arrayList.add(SvnCommandLine.validRev(string4));
        }
        arrayList.add("--force-log");
        arrayList.add("-m");
        arrayList.add(string3);
        arrayList.add(string);
        arrayList.add(string2);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    void copy(String string, String string2) throws CmdLineException {
        this.setCommand(6, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cp");
        arrayList.add(string);
        arrayList.add(string2);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String delete(String[] stringArray, String string, boolean bl) throws CmdLineException {
        this.setCommand(7, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("rm");
        if (string != null) {
            arrayList.add("--force-log");
            arrayList.add("-m");
            arrayList.add(string);
        }
        if (bl) {
            arrayList.add("--force");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    InputStream diff(String string, String string2, String string3, String string4, boolean bl) throws CmdLineException {
        this.setCommand(17, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("diff");
        if (string4 != null) {
            arrayList.add("-r");
            if (string4.equals("WORKING")) {
                arrayList.add(string2);
            } else {
                arrayList.add(string2 + ":" + string4);
            }
        }
        arrayList.add("--old");
        arrayList.add(string);
        arrayList.add("--new");
        arrayList.add(string3);
        this.addConfigInfo(arrayList);
        Process process = this.execProcess(arrayList);
        return process.getInputStream();
    }

    void export(String string, String string2, String string3, boolean bl) throws CmdLineException {
        this.setCommand(8, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("export");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string3));
        arrayList.add(string);
        arrayList.add(string2);
        if (bl) {
            arrayList.add("--force");
        }
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String importFiles(String string, String string2, String string3, boolean bl) throws CmdLineException {
        this.setCommand(9, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("import");
        arrayList.add(string);
        arrayList.add(string2);
        if (!bl) {
            arrayList.add("-N");
        }
        arrayList.add("--force-log");
        arrayList.add("-m");
        arrayList.add(string3);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    String info(String[] stringArray) throws CmdLineException {
        if (stringArray.length == 0) {
            return "";
        }
        this.setCommand(19, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("info");
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return this.execString(arrayList, false);
    }

    byte[] list(String string, String string2, boolean bl) throws CmdLineException {
        this.setCommand(11, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("list");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add("--xml");
        arrayList.add("-r");
        arrayList.add(string2);
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execBytes(arrayList, false);
    }

    byte[] log(String string, String string2, boolean bl, long l) throws CmdLineException {
        this.setCommand(13, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("log");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string2));
        arrayList.add(string);
        arrayList.add("--xml");
        if (bl) {
            arrayList.add("--stop-on-copy");
        }
        if (l > 0L) {
            arrayList.add("--limit");
            arrayList.add(Long.toString(l));
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execBytes(arrayList, true);
    }

    byte[] logVerbose(String string, String string2, boolean bl, long l) throws CmdLineException {
        this.setCommand(13, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("log");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string2));
        arrayList.add(string);
        arrayList.add("--xml");
        arrayList.add("-v");
        if (bl) {
            arrayList.add("--stop-on-copy");
        }
        if (l > 0L) {
            arrayList.add("--limit");
            arrayList.add(Long.toString(l));
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execBytes(arrayList, true);
    }

    void mkdir(String string, String string2) throws CmdLineException {
        this.setCommand(10, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mkdir");
        arrayList.add("--force-log");
        arrayList.add("-m");
        arrayList.add(string2);
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    void mkdir(String string) throws CmdLineException {
        this.setCommand(10, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mkdir");
        arrayList.add(string);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String move(String string, String string2, String string3, String string4, boolean bl) throws CmdLineException {
        this.setCommand(5, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("mv");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string4));
        arrayList.add(string);
        arrayList.add(string2);
        if (string3 != null) {
            arrayList.add("--force-log");
            arrayList.add("-m");
            arrayList.add(string3);
        }
        if (bl) {
            arrayList.add("--force");
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    InputStream propget(String string, String string2) throws CmdLineException {
        this.setCommand(20, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("propget");
        arrayList.add("--strict");
        arrayList.add(string2);
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        Process process = this.execProcess(arrayList);
        return process.getInputStream();
    }

    void propset(String string, String string2, String string3, boolean bl) throws CmdLineException {
        this.setCommand(14, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("propset");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String proplist(String string, boolean bl) throws CmdLineException {
        this.setCommand(21, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("proplist");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    void propdel(String string, String string2, boolean bl) throws CmdLineException {
        this.setCommand(15, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("propdel");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(string);
        arrayList.add(string2);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    void propsetFile(String string, String string2, String string3, boolean bl) throws CmdLineException {
        this.setCommand(14, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("propset");
        if (bl) {
            arrayList.add("-R");
        }
        arrayList.add(string);
        arrayList.add("-F");
        arrayList.add(string2);
        arrayList.add(string3);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String revert(String[] stringArray, boolean bl) throws CmdLineException {
        this.setCommand(16, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("revert");
        if (bl) {
            arrayList.add("-R");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    void resolved(String[] stringArray, boolean bl) throws CmdLineException {
        this.setCommand(22, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("resolved");
        if (bl) {
            arrayList.add("-R");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    byte[] status(String[] stringArray, boolean bl, boolean bl2, boolean bl3) throws CmdLineException {
        if (stringArray.length == 0) {
            return new byte[0];
        }
        this.setCommand(12, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("status");
        arrayList.add("--xml");
        if (bl2) {
            arrayList.add("-v");
        }
        if (!bl) {
            arrayList.add("-N");
        }
        if (bl3) {
            arrayList.add("-u");
        }
        if (bl2) {
            arrayList.add("--no-ignore");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execBytes(arrayList, false);
    }

    String update(String string, String string2) throws CmdLineException {
        this.setCommand(4, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("up");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string2));
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    String update(String[] stringArray, String string) throws CmdLineException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        this.setCommand(4, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("up");
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string));
        arrayList.add(stringBuffer.toString());
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    byte[] annotate(String string, String string2, String string3) throws CmdLineException {
        this.setCommand(25, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("annotate");
        arrayList.add("--xml");
        arrayList.add("-r");
        if (string2 != null && string2.length() > 0) {
            arrayList.add(SvnCommandLine.validRev(string2) + ":" + SvnCommandLine.validRev(string3));
        } else {
            arrayList.add(SvnCommandLine.validRev(string3));
        }
        arrayList.add(string);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execBytes(arrayList, false);
    }

    String switchUrl(String string, String string2, String string3) throws CmdLineException {
        this.setCommand(26, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sw");
        arrayList.add(string2);
        arrayList.add(string);
        arrayList.add("-r");
        arrayList.add(SvnCommandLine.validRev(string3));
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    String relocate(String string, String string2, String string3, boolean bl) throws CmdLineException {
        this.setCommand(30, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("sw");
        arrayList.add("--relocate");
        if (!bl) {
            arrayList.add("-N");
        }
        arrayList.add(string);
        arrayList.add(string2);
        arrayList.add(string3);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    String merge(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2, boolean bl3) throws CmdLineException {
        this.setCommand(27, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("merge");
        if (!bl2) {
            arrayList.add("-N");
        }
        if (bl) {
            arrayList.add("--force");
        }
        if (bl3) {
            arrayList.add("--dry-run");
        }
        if (string.equals(string3)) {
            arrayList.add("-r");
            arrayList.add(SvnCommandLine.validRev(string2) + ":" + SvnCommandLine.validRev(string4));
            arrayList.add(string);
        } else {
            arrayList.add(string + "@" + SvnCommandLine.validRev(string2));
            arrayList.add(string3 + "@" + SvnCommandLine.validRev(string4));
        }
        arrayList.add(string5);
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        return this.execString(arrayList, false);
    }

    void revpropset(String string, String string2, String string3, String string4, boolean bl) throws CmdLineException {
        this.setCommand(14, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("propset");
        arrayList.add(string);
        arrayList.add("--revprop");
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add("-r");
        arrayList.add(string4);
        if (bl) {
            arrayList.add("--force");
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        this.execVoid(arrayList);
    }

    String lock(Object[] objectArray, String string, boolean bl) throws CmdLineException {
        this.setCommand(28, true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("lock");
        if (bl) {
            arrayList.add("--force");
        }
        if (string != null && !string.equals("")) {
            arrayList.add("-m");
            arrayList.add(string);
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return this.execString(arrayList, false);
    }

    String unlock(Object[] objectArray, boolean bl) throws CmdLineException {
        this.setCommand(29, true);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("unlock");
        if (bl) {
            arrayList.add("--force");
        }
        this.addAuthInfo(arrayList);
        this.addConfigInfo(arrayList);
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        return this.execString(arrayList, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyFromSvnOutput(String string) {
        this.rev = -1L;
        super.notifyFromSvnOutput(string);
        if (this.parseSvnOutput) {
            CmdLineNotify cmdLineNotify = new CmdLineNotify(){

                public void onNotify(String string, int n, int n2, String string2, int n3, int n4, long l) {
                    if (string != null) {
                        SvnCommandLine.this.notificationHandler.notifyListenersOfChange(string);
                    }
                    if (l != -1L) {
                        SvnCommandLine.this.rev = l;
                        SvnCommandLine.this.notificationHandler.logRevision(l, string);
                    }
                }
            };
            try {
                this.svnOutputParser.addListener(cmdLineNotify);
                this.svnOutputParser.parse(string);
            }
            finally {
                this.svnOutputParser.removeListener(cmdLineNotify);
            }
        }
    }

    protected void notifyMessagesFromSvnOutput(String string) {
        this.rev = -1L;
        super.notifyFromSvnOutput(string);
    }

    protected void setCommand(int n, boolean bl) {
        this.parseSvnOutput = bl;
        this.notificationHandler.setCommand(n);
    }

    public long getRevision() {
        return this.rev;
    }
}

