% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{gg_df.rspde_result}
\alias{gg_df.rspde_result}
\title{Data frame for rspde_result objects to be used in ggplot2}
\usage{
\method{gg_df}{rspde_result}(
  result,
  parameter = result$params,
  transform = TRUE,
  restrict_x_axis = NULL,
  restrict_quantiles = NULL,
  ...
)
}
\arguments{
\item{result}{An rspde_result object.}

\item{parameter}{Vector. Which parameters to get the posterior density in the data.frame? The options are \code{std.dev}, \code{range}, \code{tau}, \code{kappa} and \code{nu}.}

\item{transform}{Should the posterior density be given in the original scale?}

\item{restrict_x_axis}{Variables to restrict the range of x axis based on quantiles.}

\item{restrict_quantiles}{Named list of quantiles to restrict x axis. It should contain the name of the parameter
along with a vector with two elements specifying the lower and upper quantiles. The names should be
match the ones in result$params. For example, if we want to restrict nu to the 0.05 and 0.95 quantiles
we do \code{restrict_quantiles = c(0.05, 0.95)}.}

\item{...}{currently not used.}
}
\value{
A data frame containing the posterior densities.
}
\description{
Returns a ggplot-friendly data-frame with the marginal posterior densities.
}
