% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla_rspde.R
\name{plot.rspde.result}
\alias{plot.rspde.result}
\title{Posterior plots for field parameters for an \code{inla.rspde} model from a \code{rspde.result} object}
\usage{
\method{plot}{rspde.result}(
  x,
  which = c("tau", "kappa", "nu"),
  caption = list("Posterior density for tau", "Posterior density for kappa",
    "Posterior density for nu"),
  sub.caption = NULL,
  type_plot = "l",
  ask = prod(graphics::par("mfcol")) < length(which) && grDevices::dev.interactive(),
  main = "",
  cex.oma.main = 1.25,
  cex.caption = 1,
  ylab = "Density",
  xlab = "x",
  ...
)
}
\arguments{
\item{x}{A \code{rspde.result} object.}

\item{which}{For which parameters the posterior should be plotted?}

\item{caption}{captions to appear above the plots; character vector or list of valid graphics annotations. Can be set to "" or NA to suppress all captions.}

\item{sub.caption}{common title-above the figures if there are more than one.}

\item{type_plot}{what type of plot should be drawn. The default is 'l'.}

\item{ask}{logical; if \code{TRUE}, the user is asked before each plot.}

\item{main}{character; title to be placed at each plot additionally (and above) all captions.}

\item{cex.oma.main}{controls the size of the sub.caption only if that is above the figures when there is more than one.}

\item{cex.caption}{controls the size of caption.}

\item{ylab}{Label for y axis.}

\item{xlab}{Label for x axis.}

\item{...}{Additional arguments.}
}
\value{
Called for its side effects.
}
\description{
Posterior plots for rSPDE field parameters in their original scales.
}
\examples{
\donttest{
library(INLA)
set.seed(123)
loc <- matrix(runif(150 * 2), 150, 2)
mesh <- inla.mesh.2d(loc = loc, max.edge = c(0.1, 0.5))
rspde <- rspde.matern(mesh)
index <- rspde.make.index(name = "spatial", n.spde = rspde$n.spde, 
n.repl = 2, dim = 2)
spatial.A <- rspde.make.A(mesh=mesh, loc=loc,
                             index = rep(1:nrow(loc), 2),
                             repl = rep(1:2, each = nrow(loc))
)
y <- 10 + rnorm(150 * 2)
stack <- inla.stack(
 data = list(y = y),
 A = list(spatial.A),
 effects = list(c(index, list(intercept = 1))),
 tag = "tag"
)
data <- inla.stack.data(stack, spde = rspde)
formula <- y ~ -1 + intercept + f(spatial,
                                  model = rspde,
                                 replicate = spatial.repl
)
result <- inla(formula,
               family = "gaussian", data = data,
               control.predictor = list(A = inla.stack.A(stack))
)
result <- rspde.result(result, "spatial", rspde)
plot(result)
}
}
