% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{set_RMF_indWeight}
\alias{set_RMF_indWeight}
\title{In a RMF fitness landscape model, there is a weighting value applied to the independent
fitness contribution term.  This function calculates that value for the run}
\usage{
set_RMF_indWeight(func_simModel = getOption("shape_simModel"),
  func_numDraws = 1e+08, func_distType = getOption("shape_constDist"),
  func_distParms = getOption("shape_const_distParameters"),
  func_const_RMF_theta = getOption("shape_const_RMF_theta"))
}
\arguments{
\item{func_simModel}{This is the model of fitness landscape being considered}

\item{func_numDraws}{This is the number of draws taken from the independent term's distribution
so that we can identify the amount of variance in that distribution.  It should be a large integer -- eg 5e7}

\item{func_distType}{This is the distribution string reference for this run}

\item{func_distParms}{These are the parameters for this runs distribution function}

\item{func_const_RMF_theta}{This is the theta value which is multiplied to the variance in the distribution.
The value returned will be a product of this numeric and the variance calulated.
From Neidhart 2014 theta is measured as:  theta = c / sqrt var random_component
and so if we want to calculate "c" we return the product of theta and sqrt of variance in the distribution}
}
\value{
A single numeric value, which may be NA if a non Rough Mount Fuji model is being simulated
}
\description{
In a RMF fitness landscape model, there is a weighting value applied to the independent
fitness contribution term.  This function calculates that value for the run
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

