% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{pt.cut}
\alias{pt.cut}
\title{pt.cut}
\usage{
pt.cut(pt, tStart = -Inf, tEnd = Inf)
}
\arguments{
\item{pt}{PitchTier object}

\item{tStart}{beginning time of interval to be cut (default -Inf = cut from the tMin of the PitchTier)}

\item{tEnd}{final time of interval to be cut (default Inf = cut to the tMax of the PitchTier)}
}
\value{
PitchTier object
}
\description{
Cut the specified interval from the PitchTier and preserve time
}
\examples{
pt <- pt.sample()
pt2 <-   pt.cut(pt,  tStart = 3)
pt2_0 <- pt.cut0(pt, tStart = 3)
pt3 <-   pt.cut(pt,  tStart = 2, tEnd = 3)
pt3_0 <- pt.cut0(pt, tStart = 2, tEnd = 3)
pt4 <-   pt.cut(pt,  tEnd = 1)
pt4_0 <- pt.cut0(pt, tEnd = 1)
pt5 <-   pt.cut(pt,  tStart = -1, tEnd = 1)
pt5_0 <- pt.cut0(pt, tStart = -1, tEnd = 1)
\dontrun{
pt.plot(pt)
pt.plot(pt2)
pt.plot(pt2_0)
pt.plot(pt3)
pt.plot(pt3_0)
pt.plot(pt4)
pt.plot(pt4_0)
pt.plot(pt5)
pt.plot(pt5_0)
}
}
\seealso{
\code{\link{pt.cut0}}, \code{\link{pt.read}}, \code{\link{pt.plot}}, \code{\link{pt.Hz2ST}}, \code{\link{pt.interpolate}}, \code{\link{pt.legendre}}, \code{\link{pt.legendreSynth}}, \code{\link{pt.legendreDemo}}
}
