% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMouse-functions.R
\name{specialKey}
\alias{specialKey}
\title{Send special key input}
\usage{
specialKey(key = "ESC", failSafe = TRUE)
}
\arguments{
\item{key}{"ESC", "ENTER" or "TAB" as string.}

\item{failSafe}{Logical flag to allow for emergency stops. Default is \code{TRUE}.}
}
\description{
Send special keys like "ESC", "ENTER" or "TAB"
}
\note{
If failSafe is \code{TRUE}, the function checks whether the mouse cursor is at the upper left position of the screen (pixel: x = 0, y = 0) . If so, the function fails and throws an error, allowing for emergency stops during code execution.
}
\examples{
\dontrun{
specialKey("ENTER")  # send ENTER
specialKey("ESC")    # send ESC
}
}
\seealso{
\code{\link{type}}, \code{\link{delay}}
}
\keyword{type}
