% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.Report.r
\name{MVP.Report.Density}
\alias{MVP.Report.Density}
\title{SNP Density}
\usage{
MVP.Report.Density(
  Pmap,
  col = c("darkgreen", "yellow", "red"),
  dpi = 300,
  outpath = getwd(),
  memo = "MVP",
  bin.size = 1e+06,
  bin.max = NULL,
  file.type = "jpg",
  file.output = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{Pmap}{P value Map}

\item{col}{The color vector}

\item{dpi}{Number. Dots per inch for .jpg and .tiff files}

\item{outpath}{Only when file.output = TRUE, determines the path of the output file}

\item{memo}{Character. A text marker on output files}

\item{bin.size}{the window size for counting SNP number}

\item{bin.max}{maximum SNP number, for winows, which has more SNPs than bin.max, will be painted in same color}

\item{file.type}{format of output figure}

\item{file.output}{Whether to output the file}

\item{verbose}{whether to print detail.}
}
\value{
Output file:
<memo>.SNP_Density.<type>
}
\description{
SNP Density
}
\examples{
data(pig60K, package = "rMVP")

MVP.Report.Density(pig60K, file.output=FALSE)

}
