% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.K.VanRaden.r
\name{MVP.K.VanRaden}
\alias{MVP.K.VanRaden}
\title{Calculate Kinship matrix by VanRaden method}
\usage{
MVP.K.VanRaden(M, priority = c("speed", "memory"), cpu = 1, verbose = TRUE)
}
\arguments{
\item{M}{Genotype, m * n, m is marker size, n is population size}

\item{priority}{speed or memory}

\item{cpu}{the number of cpu}

\item{verbose}{whether to print detail.}
}
\value{
K, n * n matrix
}
\description{
Build date: Dec 12, 2016
Last update: Dec 12, 2019
}
\examples{
\donttest{
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

K <- MVP.K.VanRaden(genotype, cpu=1)
}

}
