% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.length.R
\name{msc.length}
\alias{msc.length}
\title{Length of minicircles}
\usage{
msc.length(file, samples, groups)
}
\arguments{
\item{file}{the name of the FASTA file that contains all the minicircle sequences. The file should be in the format "all.minicircles.circ.fasta".}

\item{samples}{a character vector containing the sample names.}

\item{groups}{a vector of the same length as the samples, specifying the groups (e.g., subspecies) to which the samples belong.}
}
\value{
\item{length}{a numerical vector containing the lengths of the minicircle sequences. Each element corresponds to the length of a specific minicircle sequence.}
\item{plot}{a histogram that visualizes the frequency distribution of minicircle sequence lengths. The histogram provides an overview of the length distribution of the minicircles.}
}
\description{
The msc.length function allows you to check the length of minicircle sequences based on a single FASTA file. This function helps determine the size distribution of minicircle sequences.
}
\examples{
require(ggplot2)
require(ggpubr)

### run function
bf <- msc.length(file = system.file("extdata", "all.minicircles.fasta", package="rKOMICS"),
                 samples = exData$samples, groups = exData$subspecies)
af <- msc.length(file = system.file("extdata", "all.minicircles.circ.fasta", package="rKOMICS"),
                 samples = exData$samples, groups = exData$subspecies)

length(which(bf$length<800)) 
length(which(bf$length>1400)) 

### visualize results
hist(af$length, breaks=50)

### alter plot
ggarrange(bf$plot + labs(caption = "Before filtering"), 
          af$plot + labs(caption = "After filtering"), nrow=2)


}
