% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jst_reversed.R
\name{jst_reversed}
\alias{jst_reversed}
\title{Run a reversed Joint Sentiment Topic model}
\usage{
jst_reversed(
  dfm,
  sentiLexInput = NULL,
  numSentiLabs = 3,
  numTopics = 10,
  numIters = 3,
  updateParaStep = -1,
  alpha = -1,
  beta = -1,
  gamma = -1,
  excludeNeutral = FALSE
)
}
\arguments{
\item{dfm}{A quanteda dfm object}

\item{sentiLexInput}{Optional: A quanteda dictionary object for semi-supervised learning. If
a dictionary is used, \code{numSentiLabs} will be overridden by the number of categories in the
dictionary object. An extra category will by default be added for neutral words. This can be
turned off by setting \code{excludeNeutral = TRUE}.}

\item{numSentiLabs}{Integer, the number of sentiment labels (defaults to 3)}

\item{numTopics}{Integer, the number of topics (defaults to 10)}

\item{numIters}{Integer, the number of iterations (defaults to 3 for test runs, optimize by hand)}

\item{updateParaStep}{Integer. The number of iterations between optimizations
of hyperparameter alpha}

\item{alpha}{Double, hyperparameter for (defaults to .05*(average docsize/number of topics))}

\item{beta}{Double, hyperparameter for (defaults to .01, with multiplier .9/.1 for sentiment dictionary presence)}

\item{gamma}{Double, hyperparameter for (defaults to .05 * (average docsize/number of sentitopics)}

\item{excludeNeutral}{Boolean. If a dictionary is used, an extra category is added for neutral
words. Words in the dictionary receive a low probability of being allocated there. If this is set
to \code{TRUE}, the neutral sentiment category will be omitted. The variable is irrelevant if no
dictionary is used. Defaults to \code{FALSE}.}
}
\value{
A JST_reversed.result object containing a data.frame for each estimated
parameter
}
\description{
Estimates a reversed joint sentiment topic model using a Gibbs sampler, see Details for model description.
}
\details{
Lin, C., He, Y., Everson, R. and Ruger, S., 2012. Weakly supervised joint sentiment-topic
detection from text. IEEE Transactions on Knowledge and Data engineering, 24(6), pp.1134-1145.
}
\examples{
model <- jst(quanteda::dfm(quanteda::data_corpus_irishbudget2010),
             paradigm(),
             numTopics = 5,
             numIters = 150)

}
