% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTRLProx_Hashing.R
\name{FTRLProx_Hashing}
\alias{FTRLProx_Hashing}
\title{Feature Hashing for FTRL-Proximal Model}
\usage{
FTRLProx_Hashing(formula = ~., data, hash.size, signed.hash, verbose = TRUE)
}
\arguments{
\item{formula}{formula or a character vector of column names (will be expanded to a formula)}

\item{data}{a \code{data.frame} or \code{data.table}. The original data.}

\item{hash.size}{positive integer. The hash size of feature hashing.}

\item{signed.hash}{logical value. Indicating if the hashed value is multipled by random sign.
This will reduce the impact of collision. Disable it will enhance the speed.}

\item{verbose}{logical value. Indicating if the progress bar is displayed or not.}
}
\value{
an object of class "dgCMatrix"
}
\description{
Feature Hashing for FTRL-Proximal Algorithm. A wrapper of \code{hashed.model.matrix} function in the FeatureHashing package.
Please always use this function to generate sparse matrix for training and prediction.
}
\examples{
library(data.table)
library(FeatureHashing)
data(ipinyou)
m.train <- FTRLProx_Hashing(~ 0 + ., ipinyou.train[, -"IsClick", with = FALSE],
                            hash.size = 2^13, signed.hash = FALSE, verbose = TRUE)
m.test <- FTRLProx_Hashing(~ 0 + ., ipinyou.test[,-"IsClick", with = FALSE],
                           hash.size = 2^13, signed.hash = FALSE, verbose = TRUE)
}

