% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readFASTA.R
\name{readFASTA}
\alias{readFASTA}
\title{Read DNA/RNA Sequences in FASTA Format}
\usage{
readFASTA(file, legacy.mode = TRUE, seqonly = FALSE)
}
\arguments{
\item{file}{The name of the file which the sequences in fasta format are
            to be read from. If it does not contain an absolute or
            relative path, the file name is relative to the current
            working directory, \code{\link{getwd}}.
            The default here is to read the \code{example.fasta} file which
            is present in the \code{protseq} directory of the protr package.}

\item{legacy.mode}{If set to \code{TRUE}, lines starting with a semicolon ';'
are ignored. Default value is \code{TRUE}.}

\item{seqonly}{If set to \code{TRUE}, only sequences as returned without
               attempt to modify them or to get their names and
               annotations (execution time is divided approximately
               by a factor 3). Default value is \code{FALSE}.}
}
\value{
The result character vector
}
\description{
Read DNA/RNA Sequences in FASTA Format
}
\details{
This function reads DNA/RNA sequences in FASTA format.
}
\note{
Note
}
\examples{
x = readFASTA(system.file('dnaseq/hs.fasta', package = 'rDNAse'))
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>
}
\references{
Pearson, W.R. and Lipman, D.J. (1988)
Improved tools for biological sequence comparison.
\emph{Proceedings of the National Academy of Sciences
of the United States of America}, \bold{85}: 2444-2448
}
\keyword{FASTA}
\keyword{read}

