% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_tests.R
\name{allele.freq}
\alias{allele.freq}
\title{Generate allele frequency table (from genotypes)}
\usage{
allele.freq(gtt, verbose = TRUE)
}
\arguments{
\item{gtt}{a genotype table produced from \code{hetTgen} (or similar)}

\item{verbose}{logical. whether to show the progress of the analysis}
}
\value{
Returns a data frame of allele frequencies calculated from genotypes
}
\description{
Get alternative allele frequency across all individuals per SNP from the
genotype table
}
\details{
Use hetTgen function to generate the genotype table with the
\code{GT} option
}
\examples{
vcf.file.path <- paste0(path.package("rCNV"), "/example.raw.vcf.gz")
vcf <- readVCF(vcf.file.path=vcf.file.path)
het.table<-hetTgen(vcf,"GT")
frQ<-allele.freq(het.table)

}
\author{
Piyal Karunarathne
}
