/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.spi.FilterReply;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.Slf4JLoggingSystem;
import org.springframework.boot.logging.logback.DefaultLogbackConfiguration;
import org.springframework.boot.logging.logback.LogbackConfigurator;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class LogbackLoggingSystem
extends Slf4JLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;
    private static final TurboFilter FILTER;

    public LogbackLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String[] getStandardConfigLocations() {
        return new String[]{"logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml"};
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.getLogger(null).getLoggerContext().getTurboFilterList().add((Object)FILTER);
        this.configureJBossLoggingToUseSlf4j();
    }

    @Override
    public void initialize(String configLocation, LogFile logFile) {
        this.getLogger(null).getLoggerContext().getTurboFilterList().remove((Object)FILTER);
        super.initialize(configLocation, logFile);
    }

    @Override
    protected void loadDefaults(LogFile logFile) {
        LoggerContext context = this.getLoggerContext();
        context.stop();
        context.reset();
        LogbackConfigurator configurator = new LogbackConfigurator(context);
        new DefaultLogbackConfiguration(logFile).apply(configurator);
    }

    @Override
    protected void loadConfiguration(String location, LogFile logFile) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (logFile != null) {
            logFile.applyToSystemProperties();
        }
        LoggerContext context = this.getLoggerContext();
        context.stop();
        context.reset();
        try {
            URL url = ResourceUtils.getURL((String)location);
            new ContextInitializer(context).configureByResource(url);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Logback logging from " + location, ex);
        }
    }

    @Override
    protected void reinitialize() {
        this.getLoggerContext().reset();
        this.loadConfiguration(this.getSelfInitializationConfig(), null);
    }

    private void configureJBossLoggingToUseSlf4j() {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        this.getLogger(loggerName).setLevel(LEVELS.get((Object)level));
    }

    private Logger getLogger(String name) {
        LoggerContext factory = this.getLoggerContext();
        return factory.getLogger(StringUtils.isEmpty((Object)name) ? "ROOT" : name);
    }

    private LoggerContext getLoggerContext() {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, (String)String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s). If you are using Weblogic you will need to add 'org.slf4j' to prefer-application-packages in WEB-INF/weblogic.xml", factory.getClass(), this.getLocation(factory)));
        return (LoggerContext)factory;
    }

    private Object getLocation(ILoggerFactory factory) {
        try {
            ProtectionDomain protectionDomain = factory.getClass().getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                return codeSource.getLocation();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return "unknown location";
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.ERROR);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
        FILTER = new TurboFilter(){

            public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
                return FilterReply.DENY;
            }
        };
    }
}

