% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amDataset.R
\name{amStockMultiSet}
\alias{amStockMultiSet}
\title{Plotting multi data-sets}
\usage{
amStockMultiSet(data, panelColumn = NULL, ZoomButtonPosition = "bottom",
  ZoomButton = data.frame(Unit = "MAX", multiple = 1, label = "All"),
  color = c("#2E2EFE", "#31B404", "#FF4000"), precision = 1,
  export = FALSE, percentHeightPanel = NULL,
  creditsPosition = "top-right", ...)
}
\arguments{
\item{data}{\code{list}, list of data.frame (same structure) first column is date, others are values}

\item{panelColumn}{\code{numeric}, numeric vector, controle panel adding for selected series}

\item{ZoomButtonPosition}{\code{character}, zoom button position. Possible values are :
"left", "right", "bottom", "top"}

\item{ZoomButton}{\code{data.frame}, 3 columns : 
Unit, times unit
multiple : multiple*unit 
label : button's label}

\item{color}{\code{character}, color of data-sets (in hexadecimal).}

\item{precision}{\code{numeric}, digits precision}

\item{export}{\code{logical}, default set to  FALSE. TRUE to display export feature.}

\item{percentHeightPanel}{\code{numeric}, vector of size panel, same length than data}

\item{creditsPosition}{\code{character}, credits position. Possible values are :
"top-right", "top-left", "bottom-right", "bottom-left"}

\item{...}{other first level attributes}
}
\description{
amStockMultiSet compute a stock of multi data-sets
}
\examples{

\dontrun{
data(data_stock_3)

amStockMultiSet(data = data_stock_3)
amStockMultiSet(data = data_stock_3, panelColumn = c(1,2,1,1))

amStockMultiSet(data = data_stock_3, panelColumn = c(1,2,3,4))

ZoomButton <- data.frame(Unit = c("DD", "DD", "MAX"), multiple = c(1, 10 ,1),
                   label = c("Day","10 days", "MAX"))
                   ZoomButtonPosition <- "bottom"
amStockMultiSet(data = data_stock_3, panelColumn = c(1,2,1,1), ZoomButton = ZoomButton,
ZoomButtonPosition = "top")

amStockMultiSet(data = data_stock_3, precision = 2)

amStockMultiSet(data = data_stock_3, panelColumn = c(1,2,1,1), percentHeightPanel = c(3,1))
}


}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
