% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/travel_time_matrix.R
\name{travel_time_matrix}
\alias{travel_time_matrix}
\title{Calculate travel time matrix between origin destination pairs}
\usage{
travel_time_matrix(
  r5r_core,
  origins,
  destinations,
  mode = "WALK",
  departure_datetime = Sys.time(),
  max_walk_dist = Inf,
  max_trip_duration = 120L,
  walk_speed = 3.6,
  bike_speed = 12,
  max_rides = 3,
  n_threads = Inf,
  verbose = TRUE
)
}
\arguments{
\item{r5r_core}{a rJava object to connect with R5 routing engine}

\item{origins, destinations}{a spatial sf POINT object, or a data.frame
containing the columns 'id', 'lon', 'lat'}

\item{mode}{string. Transport modes allowed for the trips. Defaults to
"WALK". See details for other options.}

\item{departure_datetime}{POSIXct object. If working with public transport
networks, please check \code{calendar.txt} within
the GTFS file for valid dates.}

\item{max_walk_dist}{numeric. Maximum walking distance (in meters) for the
whole trip. Defaults to no restrictions on walking, as
long as \code{max_trip_duration} is respected.}

\item{max_trip_duration}{numeric. Maximum trip duration in minutes. Defaults
to 120 minutes (2 hours).}

\item{walk_speed}{numeric. Average walk speed in km/h. Defaults to 3.6 km/h.}

\item{bike_speed}{numeric. Average cycling speed in km/h. Defaults to 12 km/h.}

\item{max_rides}{numeric. The max number of public transport rides allowed in
the same trip. Defaults to 3.}

\item{n_threads}{numeric. The number of threads to use in parallel computing.
Defaults to use all available threads (Inf).}

\item{verbose}{logical. TRUE to show detailed output messages (the default)
or FALSE to show only eventual ERROR messages.}
}
\value{
A data.table with travel time estimates (in minutes) between origin
destination pairs by a given transport mode.
}
\description{
Fast computation of travel time estimates between one or
multiple origin destination pairs.
}
\details{
R5 allows for multiple combinations of transport modes. The options
include:
\subsection{Transit modes}{

TRAM, SUBWAY, RAIL, BUS, FERRY, CABLE_CAR, GONDOLA, FUNICULAR. The option
'TRANSIT' automatically considers all public transport modes available.
}

\subsection{Non transit modes}{

WALK, BICYCLE, CAR, BICYCLE_RENT, CAR_PARK
}
}
\examples{
\donttest{
library(r5r)

# build transport network
data_path <- system.file("extdata", package = "r5r")
r5r_core <- setup_r5(data_path = data_path)

# load origin/destination points
points <- read.csv(system.file("extdata/poa_hexgrid.csv", package = "r5r"))[1:5,]

mode <- c("WALK", "TRANSIT")
max_walk_dist <- Inf
max_trip_duration <- 120L
departure_datetime <- as.POSIXct("13-03-2019 14:00:00",
                                 format = "\%d-\%m-\%Y \%H:\%M:\%S")

# estimate travel time matrix
ttm <- travel_time_matrix(r5r_core,
                          origins = points,
                          destinations = points,
                          mode,
                          departure_datetime,
                          max_walk_dist,
                          max_trip_duration)

stop_r5(r5r_core)
rJava::.jgc(R.gc = TRUE)

}
}
\seealso{
Other routing: 
\code{\link{detailed_itineraries}()}
}
\concept{routing}
