% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSsetup.R
\name{box3js}
\alias{box3js}
\title{Add a box to an r3js plot}
\usage{
box3js(
  data3js,
  sides = c("x", "y", "z"),
  dynamic = TRUE,
  col = "grey80",
  geometry = FALSE,
  renderOrder = 1,
  ...
)
}
\arguments{
\item{data3js}{The data3js object}

\item{sides}{The axis side to show the box, any combination of "x", "y" or "z"}

\item{dynamic}{Should edges of the box closest to the viewer hide themselves automatically}

\item{col}{Box color}

\item{geometry}{Should the box be rendered as a physical geometry in the scene (see \code{lines3js()})}

\item{renderOrder}{The render order for the box, defaults to 1}

\item{...}{Other arguments to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
Add a box to an r3js plot
}
\examples{
p <- plot3js.new()
p <- box3js(p)
r3js(p)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()},
\code{\link{triangle3js}()}
}
\concept{plot components}
