% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd.R, R/set.R
\name{m_set_view}
\alias{m_set_view}
\alias{m_set_view_style}
\title{Sets the view to the specified translation, zoom, rotation and style}
\usage{
m_set_view(id, arg, style)

m_set_view_style(id, style)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{arg}{Vector formatted view setting,
\code{c(pos.x, pos.y, pos.z, rotationGroup.position.z, q.x, q.y, q.z, q.w)}.
Requires any one of \code{q.x}, \code{q.y}, \code{q.z}, \code{q.w} to be set
to \code{1} to enable mouse control, otherwise only static image is rendered.}

\item{style}{css style object in list.}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Sets the view to the specified translation, zoom, rotation and style
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_set_style(style = m_style_cartoon()) \%>\%
  m_set_view(arg = c(20, -20, 10, -200, 0, 1, 0, 0)) \%>\%
  m_add_outline(color = "blue")
}
