% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{histSPSS}
\alias{histSPSS}
\title{Histogram}
\usage{
histSPSS(data, variable, normal = FALSE, xlab = NULL, ylab = NULL, ...)
}
\arguments{
\item{data}{a data frame containing the variable to be plotted.}

\item{variable}{a character string specifying the variable to be
plotted.}

\item{normal}{a logical indicating whether to add a normal density with the
estimated mean and standard deviation (the default is \code{FALSE}).}

\item{xlab, ylab}{the axis labels (the default is to use the variable name
for the \eqn{x}-axis label and \code{"Frequency"} as the \eqn{y}-axis label).}

\item{\dots}{additional arguments to be passed down, in particular
graphical parameters (see \code{\link[graphics]{hist}} and
\code{\link[graphics]{par}}).}
}
\value{
An object of class \code{"histogram"} is returned invisibly (see
\code{\link[graphics]{hist}}).
}
\description{
Draw a histogram of a variable in a data frame.  The plot thereby mimics the
look of SPSS graphs.
}
\examples{
# load data
data("Eredivisie")
# log-transform market values
Eredivisie$logMarketValue <- log(Eredivisie$MarketValue)

# plot histogram of log market values
histSPSS(Eredivisie, "logMarketValue")

}
\author{
Andreas Alfons
}
\keyword{hplot}
