% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{formatSPSS}
\alias{formatSPSS}
\alias{formatSPSS.default}
\alias{formatSPSS.integer}
\alias{formatSPSS.numeric}
\alias{formatSPSS.matrix}
\alias{formatSPSS.data.frame}
\title{Format Objects}
\usage{
formatSPSS(x, ...)

\method{formatSPSS}{default}(x, ...)

\method{formatSPSS}{integer}(x, ...)

\method{formatSPSS}{numeric}(x, digits = 3, ...)

\method{formatSPSS}{matrix}(x, ...)

\method{formatSPSS}{data.frame}(x, ...)
}
\arguments{
\item{x}{an \R object, typically numeric.  Currently methods are
implemented for vectors, matrices and data frames.  The default method calls
\code{\link{as.character}}.}

\item{\dots}{additional arguments passed down to methods.}

\item{digits}{an integer giving the number of digits after the comma to
display.}
}
\value{
A character vector or matrix containing the formatted object.
}
\description{
Format an object for printing, mostly used to print numeric data in the same
way SPSS.  This is mainly for internal use in \code{\link{print}} methods.
}
\examples{
# note how numbers in the interval (-1, 1) are printed
# without the zero in front of the comma
formatSPSS(c(-1.5, -2/3, 2/3, 1.5))

}
\author{
Andreas Alfons
}
\keyword{utilities}
