/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.general_regression.GeneralRegressionModelUtil;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RMSConverter;
import org.jpmml.rexp.RStringVector;

public class LRMConverter
extends RMSConverter {
    public LRMConverter(RGenericVector lrm) {
        super(lrm);
    }

    @Override
    public void encodeSchema(RExpEncoder encoder) {
        RGenericVector lrm = (RGenericVector)this.getObject();
        RIntegerVector freq = lrm.getIntegerElement("freq");
        RStringVector freqNames = freq.dimnames(0);
        super.encodeSchema(encoder);
        Label label = encoder.getLabel();
        DataField dataField = (DataField)encoder.toCategorical(label.getName(), freqNames.getValues());
        encoder.setLabel(dataField);
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector lrm = (RGenericVector)this.getObject();
        RDoubleVector coefficients = lrm.getDoubleElement("coefficients");
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        SchemaUtil.checkSize((int)2, (CategoricalLabel)categoricalLabel);
        Object targetCategory = categoricalLabel.getValue(1);
        Double intercept = (Double)coefficients.getElement(this.getInterceptName(), false);
        List features = schema.getFeatures();
        SchemaUtil.checkSize((int)(coefficients.size() - (intercept != null ? 1 : 0)), (List)features);
        List<Double> featureCoefficients = this.getFeatureCoefficients(features, coefficients);
        GeneralRegressionModel generalRegressionModel = new GeneralRegressionModel(GeneralRegressionModel.ModelType.GENERALIZED_LINEAR, MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), null, null, null).setLinkFunction(GeneralRegressionModel.LinkFunction.LOGIT).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (CategoricalLabel)categoricalLabel));
        GeneralRegressionModelUtil.encodeRegressionTable((GeneralRegressionModel)generalRegressionModel, (List)features, featureCoefficients, (Number)intercept, (Object)targetCategory);
        return generalRegressionModel;
    }
}

