/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Value;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueDecorator;

public class ValidValueDecorator
extends ValueDecorator {
    private List<Interval> intervals = new ArrayList<Interval>();

    public ValidValueDecorator() {
        super(Value.Property.VALID);
    }

    @Override
    public void decorate(DataField dataField, MiningField miningField) {
        List<Interval> intervals = this.getIntervals();
        if (intervals.size() > 0) {
            PMMLUtil.addIntervals(dataField, intervals);
        }
        super.decorate(dataField, miningField);
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public ValidValueDecorator addIntervals(Interval ... intervals) {
        this.getIntervals().addAll(Arrays.asList(intervals));
        return this;
    }

    @Override
    public ValidValueDecorator addValues(Object ... values) {
        return (ValidValueDecorator)super.addValues(values);
    }
}

