/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;

public class BooleanFeature
extends CategoricalFeature
implements HasDerivedName {
    public static final List<Object> VALUES = ImmutableList.of((Object)Boolean.FALSE, (Object)Boolean.TRUE);

    public BooleanFeature(PMMLEncoder encoder, Field<?> field) {
        this(encoder, field.getName());
    }

    public BooleanFeature(PMMLEncoder encoder, Feature feature) {
        this(encoder, feature.getName());
    }

    public BooleanFeature(PMMLEncoder encoder, FieldName name) {
        super(encoder, name, DataType.BOOLEAN, VALUES);
    }

    @Override
    public FieldName getDerivedName() {
        return FieldName.create((String)(this.getName().getValue() + "=true"));
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        return this.toContinuousFeature(this.getDerivedName(), DataType.DOUBLE, () -> new NormDiscrete(this.getName(), (Object)Boolean.TRUE));
    }
}

