\name{r2lUniv.data.frame}
\alias{r2lUniv.data.frame}

\title{Method for data frame}
\description{
  Method used by \code{r2lUniv} for \code{data.frame}.
  
  On a \code{data.frame}, \code{r2lUniv} chooses the
  \link[=r2lConcepts]{r2lUniv basic classes}
  then runs the \link[=r2lConcepts]{r2lUniv basic analysis} on every column
  and finally exports the LaTeX code.
}
\usage{
\method{r2lUniv}{data.frame}(data, fileOutput = "", varName = "", varNumber = "", dirGraph = "", graphName = "V", limDiscrete = 10, classModification = "",...)
}

\arguments{
  \item{data}{\code{data.frame};
    to print}

  \item{fileOutput}{\code{character};
    name of the output file to save the LaTeX code. If
    empty, code is printed on screen.}

  \item{varName}{\code{character}, single or vector;
    gives a name to each \link[=r2lConcepts]{LaTeX summary}. The following values are possible :
    \itemize{
      \item \code{varName=""}: The names of the \code{data.frame} columns are used.
      \item \code{varName=NA}: No title.
      \item \code{varName="Title"}: \code{Title} will be used for all the
      variables. It might be useful in conjonction with
      \code{varNumber=""}
      \item \code{varName=c("Name1","Name2","...")}: User-defined title. The vector
      is NOT recycled, it must have one title for each column.}}
  
  \item{varNumber}{\code{numeric}, single or vector;
    gives a number to each \emph{LaTeX summury}. The following values are possible :
    \itemize{
      \item \code{varNumber=""} The number of the \code{data.frame} columns is used.
      \item \code{varNumber=NA} No number.
      \item \code{varNumber=c(4,2,...)} User-defined numbers. The vector
      is NOT recycled, it must have one number for each column.}}
  
  \item{dirGraph}{\code{character};
    Directory used to save the graph generated by the analyses.}

  \item{graphName}{\code{character}, single or vector;
    Prefix of the graphs' names. It can be a single name
    or a vector. In case of single name, it will be \code{paste} with
    \code{varNumber} if \code{varNumber} is "" or a user-defined vector;
    it will be \code{paste} with
    \code{1:length(dataFrame)} if \code{varNumber} is NA. Warnings:
    if \code{varNumber} is user-defined and some numbers are use more than
    once, different graphs will have the same name, some will be
    erased.}
  
  \item{limDiscrete}{\code{numeric};
    Fixes the limit that distinguishes continuous variables
    from discrete ones. See \code{\link{r2lFindClass}} for details.}

  \item{classModification}{Either a list \code{list(nominal=c(...), ordinal=c(...),
      discrete=c(...), continuous=c(...))}, or "";
    Allowes the user to change manually some \emph{basic type}. The list
    must have exactly four fields (potentially empty) in the specified
    order. See \code{\link{r2lModifyClasses}} for details.}

  \item{...}{For S3 compatibility only}
}

\details{
  On a \code{data.frame}, \code{r2lUniv} sets the
  \link[=r2lConcepts]{r2lUniv basic classes}
  then runs the analyses on every column.

  The \link[=r2lConcepts]{r2lUniv basic classes} are first set by the \code{\link{r2lFindClasses}}
  function; optionally, if \code{classModification} is not \code{""}, some
  classes are changed by \code{\link{r2lModifyClasses}}.

  Then \code{r2lUniv} is called on every column one by one. See \code{\link{r2lUniv.r2lBasicClasses}}.
}

\value{
  \code{r2lUniv} either prints LaTeX code on the screen or saves it in a
  file. It also generates several \emph{encapsuled postsript} graphs (.eps), optionally
  in a directory.\cr
}


\section{Classical usage}{
  The use of \code{r2lUniv} goes through the following steps:
  \tabular{ll}{
    Step 1. \tab Load the \code{data.frame}.\cr
    Step 2. \tab Optionally, set some variables as \code{ordered}. \cr
    Step 3. \tab Optionally, change the type of some variables (to force some
    \code{discrete} to be \code{continuous}, some \code{logical} to be
    \code{ordered}, ... ; see \link{r2lModifyClasses} for details. \cr
    Step 4. \tab Run \code{r2lUniv(dataFrame,"fileOut.tex")} or
    \code{r2lUniv(dataFrame,"fileOut.tex",classModification=listModif)} if the
    type of some variables must change. \cr
  }
  See examples of \code{\link{r2lUniv}} for an application [].
}




\section{R to LaTeX, Bivariate Analyses}{
  \emph{r2lBiv} (R to LaTeX, Bivariate Analyses) is under contruction. Any
  help will be welcomed!
}

\seealso{\code{\link[utils]{Sweave}},
  \code{\link[Hmisc]{latex}},
  \code{\link{r2lUniv}},
  \code{\link{r2lConcepts}},
  \code{\link{r2lUniv.r2lBasicClasses}},
  \code{\link{r2lUniv.Rclasses}},
  \code{\link{r2lFindClasses}}
}

\references{LaTeX web site \url{http://www.latex-project.org/}}

\section{Author}{
  Christophe Genolini \cr
  \email{christophe.genolini@free.fr}\cr
  PSIGIAM: Paris Sud Innovation Group in Adolescent Mental Health \cr
  INSERM U669 / Maison de Solenn / Paris
}

\section{English correction}{
  Jean-Marc Chamot \cr
  \email{jchamot@u-paris10.fr}\cr
  Laboratoire "Sport & Culture" / "Sports & Culture" Laboratory \cr
  University of Paris 10 / Nanterre
}


\examples{
 # # # # # # # # # # # # # # # # # # #
#   R to LaTeX, Univariate Analyses   #
 #             Examples              # 
  #           data.frame            #
   # # # # # # # # # # # # # # # # #



########################
###### Step 1: Load the data

data(examCheating)
str(examCheating)


########################
###### Step 2: Set ordered

examCheating$YearOfStudy <- ordered(examCheating$YearOfStudy,levels=c("L1","L2","L3","M1","M2"))
examCheating$Bac <- ordered(examCheating$Bac,levels=c("Remedial exam","Pass","Fairly good","Good","Very good","Summa cum laude"))
for(iColumn in 8:17){examCheating[,iColumn] <- ordered(examCheating[,iColumn],levels=c("Never","Rarely","Sometimes","Often","Always"))}
str(examCheating)


########################
###### Step 3: Change some classes.
### Everything seems ok


########################
###### Step 4: Run

### The following code will create some files.
### So we advise you to first move to directory "r2lUnivExample"
dir.create("r2lUnivExample")
setwd("r2lUnivExample")

r2lUniv(examCheating[,-1],"cheatAnalyses.tex")

### Creates the main document.
r2lGenerateLatexMain("cheatAnalyses.tex")

### Everything is ready, you can now run LaTeX on the file "main.tex"
setwd("..")
}

\keyword{univar}       % Simple univariate statistics
\keyword{interface}    % interface to other languages
\keyword{utilities}    % Utilities
\keyword{classes}      % Data type
\keyword{print}        % Printing

