% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_sgv_est_Function.R
\name{pqlmer}
\alias{pqlmer}
\title{pqlmer}
\usage{
pqlmer(formula, family, data, niter = 40, verbose = T)
}
\arguments{
\item{formula}{The lme4 model formula.}

\item{family}{a family function of the error distribution and link function to be used in the model.}

\item{data}{the dataframe containing the variables in the model.}

\item{niter}{Maximum number of iterations to perform.}

\item{verbose}{if TRUE, iterations are printed to console.}
}
\value{
A pseudo linear mixed model of class "lme" .
}
\description{
Fit a GLMM model with multivariate normal random effects using Penalized Quasi-Likelihood for mermod objects.
}
\examples{
# Compare lmer PQL with lme PQL

library(MASS)

lmePQL = glmmPQL(y ~ trt + week + I(week > 2), random = ~ 1 | ID,
                  family = binomial, data = bacteria,
                  verbose = FALSE)

merPQL= pqlmer(y ~ trt + week + I(week > 2) + (1 | ID),
               family = binomial, data = bacteria,
               verbose = FALSE)

summary(lmePQL)
summary(merPQL)
}
\seealso{
\code{\link{glmmPQL}}
}
