% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qroc.R
\name{qroc}
\alias{qroc}
\alias{qroc_build_data_frame}
\alias{auc}
\title{Receiver Operator Curves}
\usage{
qroc(x, ...)

qroc_build_data_frame(fit, n_threshold = 200, ...)

auc(.data)
}
\arguments{
\item{x}{a \code{glm} fit or \code{data.frame} generated by
\code{qroc_build_data_frame}.}

\item{...}{passed to \code{stats::predict}}

\item{fit}{a \code{glm} fit with \code{family = binomial()}.}

\item{n_threshold}{number of thresholds to test against.}

\item{.data}{a \code{data.frame} generated by \code{qroc_build_data_frame}.}
}
\value{
a ggplot.  Minimal aesthetics have been used so that the user may
modify the graphic as desired with ease.

AUC for the data set generated by
}
\description{
Construction of ROC curves.
}
\details{
Given a \code{glm} fit with \code{family = "binomial"} (either a log-link or
logit-link should be fine, a data set will be constructed and ROC plots
generated.

The area under the curve (AUC) is determined by a trapezoid approximation.
}
\examples{
# load ggplot2 and the diamonds data set
data(diamonds, package = "ggplot2")

# Create a logistic regression models
fit <- glm(I(price > 2800) ~ cut * color, data = diamonds, family = binomial())

qroc(fit)

}
\seealso{
\code{vignette("qwraps2-graphics", package = "qwraps2")} for more
examples.
}
