% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion_matrix.R
\name{confusion_matrix}
\alias{confusion_matrix}
\alias{confusion_matrix.default}
\alias{confusion_matrix.formula}
\alias{is.confusion_matrix}
\alias{print.confusion_matrix}
\title{Confusion Matrices (Contingency Tables)}
\usage{
confusion_matrix(x, ...)

\method{confusion_matrix}{default}(x, y, positive, boot = FALSE,
  boot_samples = 1000L, alpha = 0.05, ...)

\method{confusion_matrix}{formula}(formula, data = parent.frame(), positive,
  boot = FALSE, boot_samples = 1000L, alpha = 0.05, ...)

is.confusion_matrix(x)

\method{print}{confusion_matrix}(x, ...)
}
\arguments{
\item{x}{prediction condition vector, a two level factor variable or a
variable that can be converted to one.}

\item{...}{not currently used}

\item{y}{True Condition vector with the same possible values as x.}

\item{positive}{the level of x and y which is the positive outcome.  If
missing the first level of factor(y) will be used as the positive level.}

\item{boot}{boolean, should bootstrapped confidence intervals for the
sensitivity and specificity be computed?  Defaults to FALSE.}

\item{boot_samples}{number of bootstrapping sample to generate, defaults to
1000L.  Ignored if \code{boot == FALSE}.}

\item{alpha}{100(1-alpha)% confidence intervals for specificity and
sensitivity.  Ignored if \code{boot == FALSE}.}

\item{formula}{column (known) ~ row (test) for building the confusion matrix}

\item{data}{environment containing the variables listed in the formula}
}
\value{
The sensitivity and specificity functions return numeric values.
\code{confusion_matrix} returns a list with elements:
\itemize{
  \item tab the confusion matrix,
  \item stats a matrix of summary statistics and confidence intervals.
}
}
\description{
Construction of confusion matrices, accuracy, sensitivity,
specificity, confidence intervals (Wilson's method and (optional
bootstrapping)).
}
\details{
Sensitivity and Specificity:
For the sensitivity and specificity function we expect the 2-by-2 confusion
matrix (contingency table) to be of the form:

\tabular{lccc}{
                    \tab      \tab True \tab Condition \cr
                    \tab      \tab +    \tab -         \cr
Predicted Condition \tab +    \tab TP   \tab FP        \cr
Predicted Condition \tab -    \tab FN   \tab TN        \cr
}
where
\itemize{
  \item FN: False Negative, and
  \item FP: False Positive, 
  \item TN: True Negative,
  \item TP: True Positive.
}

Recall: 
\itemize{
  \item sensitivity = TP / (TP + FN)
  \item specificity = TN / (TN + FP) 
  \item positive predictive value (PPV) = TP / (TP + FP)
  \item negative predictive value (NPV) = TN / (TN + FN)
}
}
\examples{
## Example taken from caret::confusionMatrix
\donttest{ 
lvs <- c("normal", "abnormal")
truth <- factor(rep(lvs, times = c(86, 258)),
                levels = rev(lvs))
pred <- factor(c(rep(lvs, times = c(54, 32)),
                 rep(lvs, times = c(27, 231))),               
               levels = rev(lvs))

confusion_matrix(pred, truth)
confusion_matrix(pred, truth)$stats

confusion_matrix(pred, truth, boot = TRUE)
confusion_matrix(pred, truth, positive = "normal", boot = TRUE)

# Using formulas
test_data <- data.frame(xyz = pred, yyy = truth)
confusion_matrix(yyy ~ xyz, test_data)
confusion_matrix(yyy ~ xyz, test_data, positive = "normal") 
}

}

