% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{request}
\alias{request}
\title{Request a resource from the PGS REST API}
\usage{
request(
  resource_url,
  base_url = pgs_server(),
  user_agent = user_agent_id(),
  verbose = FALSE,
  warnings = TRUE
)
}
\arguments{
\item{resource_url}{Endpoint URL. The endpoint is internally appended to the
\code{base_url}. It should start with a forward slash (\code{'/'}).}

\item{base_url}{The PGS REST API base URL.}

\item{user_agent}{User agent.}

\item{verbose}{Whether to be verbose.}

\item{warnings}{Whether to print warnings.}
}
\value{
A named list of four elements:
\describe{
\item{resource}{The URL endpoint.}
\item{code}{\href{https://en.wikipedia.org/wiki/List_of_HTTP_status_codes}{HTTP
status code}.}
\item{message}{A string describing the status of the response obtained:
\code{'OK'} if successful or a description of the error.}
\item{json}{JSON response as string.}
}
}
\description{
Performs a \code{\link[httr]{GET}} request on the endpoint as specified by
\code{resource_url}.
}
\keyword{internal}
