% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{pgs_to_pgp}
\alias{pgs_to_pgp}
\title{Map PGS identifiers to PGP identifiers}
\usage{
pgs_to_pgp(
  pgs_id = NULL,
  verbose = FALSE,
  warnings = TRUE,
  progress_bar = TRUE
)
}
\arguments{
\item{pgs_id}{A character vector of PGS identifiers,
e.g., "PGS000001". If \code{NULL} then returns results for all PGS
identifiers in the Catalog.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if
any.}

\item{progress_bar}{Whether to show a progress bar as the queries are
performed.}
}
\value{
A data frame of two columns: \code{pgs_id} and \code{pgp_id}.
}
\description{
Map PGS identifiers to PGP identifiers.
}
\examples{
\dontrun{
pgs_to_pgp('PGS000001')
pgs_to_pgp(c('PGS000017', 'PGS000042'))
}
}
