% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotpar.R
\name{plotpar}
\alias{plotpar}
\title{Plot the values of the parameters}
\usage{
plotpar(qp, x = NULL, panel = NULL, xpanel = NULL, ypanel = NULL,
  color = NULL, geom = "bar", ci = T)
}
\arguments{
\item{qp}{output from quickpsy.}

\item{x}{Name of the variable to displayed in the x-axis.}

\item{panel}{Name of the variable to be split in panels.}

\item{xpanel}{Name of the variable to be split in horizontal panels.}

\item{ypanel}{Name of the variable to be split in vertical panels.}

\item{color}{Name of the variable codded by color.}

\item{geom}{If \code{'bar'} displays bars.
If \code{'point'} displays points (default is \code{'bar'}).}

\item{ci}{If \code{FALSE} confidence intervals are not plotted
(default is \code{TRUE}).}
}
\description{
\code{plotpar} plot the values of the parameters.
}
\examples{
library(MPDiR) # contains the Vernier data
fit <- quickpsy(Vernier, Phaseshift, NumUpward, N,
                grouping = .(Direction, WaveForm, TempFreq), B = 10)
plotpar(fit)
plotpar(fit, x = WaveForm)
plotpar(fit, xpanel = Direction)
plotpar(fit, color = Direction)
plotpar(fit, color = Direction, ypanel = WaveForm, geom = 'point')
}
\seealso{
\code{\link{plotpar_}}
}

