% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OR.R
\name{or}
\alias{or}
\alias{\%or\%}
\title{Nullish coalescing operator}
\usage{
or(test, alternative)

test \%or\% alternative
}
\arguments{
\item{test}{an object to return}

\item{alternative}{alternative object to return}
}
\value{
value of test if not null or empty, else return value of alternative
}
\description{
Alternative return for empty, null or na statements.Return alternative if the value of expression is empty or NA or NULL
}
\note{
Equivalent to Nullish coalescing operator ?? in javascript or PHP like $Var = $operand1 ?? $operand2;
}
\examples{

test1 <- c(4,NA,5,2,0,21)

test2 <- data.frame(ID = 1:10,ED = LETTERS[10:1])

or(test1[which(test1==4)],100)


or(test1[which(test1==43)],100)

or(test2[which(test2$ID == 10),2],"BBBBB")

or(test2[which(test2$ID == 323),2],"CCCCC")

# One may also choose to use
test2[which(test2$ID == 323),2] \%or\% "CCCCC"
NA \%or\% "Random"
NULL \%or\% "Random"
"" \%or\% "Random"

}
