% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{valid_test}
\alias{valid_test}
\title{Test for Invalid Elements in a Vector}
\usage{
valid_test(x, valid, na.rm = TRUE)
}
\arguments{
\item{x}{atomic vector or list vector.}

\item{valid}{atomic vector or list vector of valid values.}

\item{na.rm}{logical vector of length 1 specifying whether NA should be
ignored from the validity test. If TRUE (default), then any NAs are treated
as valid.}
}
\value{
logical vector of length 1 specifying whether all elements in
  \code{x} are valid values. If FALSE, then (at least one) invalid values are
  present.
}
\description{
\code{valid_test} tests whether a vector has any invalid elements. Valid
values are specified by \code{valid}. If the vector \code{x} has any values
other than \code{valid}, then FALSE is returned; If the vector \code{x} only
has values in \code{valid}, then TRUE is returned. This function can be
useful for checking data after manual human entry.
}
\examples{
valid_test(x = psych::bfi[[1]], valid = 1:6) # return TRUE
valid_test(x = psych::bfi[[1]], valid = 0:5) # 6 is not present in `valid`
valid_test(x = psych::bfi[[1]], valid = 1:6,
   na.rm = FALSE) # NA is not present in `valid`
}
\seealso{
\code{\link{valids_test}}
   \code{\link{revalid}}
   \code{\link{revalids}}
}
