% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{freq_by}
\alias{freq_by}
\title{Univariate Frequency Table By Group}
\usage{
freq_by(
  x,
  grp,
  exclude = if (useNA == "no") c(NA, NaN),
  useNA = "always",
  prop = FALSE,
  sort = "frequency",
  decreasing = TRUE,
  na.last = TRUE
)
}
\arguments{
\item{x}{atomic vector.}

\item{grp}{atomic vector or list of atomic vectors (e.g., data.frame)
specifying the groups. The atomic vector(s) must be the length of \code{x}
or else an error is returned.}

\item{exclude}{unique values of \code{x} to exclude from the returned table.
If NULL, then missing values are always included in the returned table. See
\code{\link{table}} for documentation on the same argument.}

\item{useNA}{character vector of length 1 specifying how to handle missing
values (i.e., whether to include NA as an element in the returned table).
There are three options: 1) "no" = don't include missing values in the
table, 2) "ifany" = include missing values if there are any, 3) "always" =
include missing values in the table, regardless of whether there are any or
not. See \code{\link{table}} for documentation on the same argument.}

\item{prop}{logical vector of length 1 specifying whether the returned table
should include counts (FALSE) or proportions (TRUE). If NAs are excluded
(e.g., useNA = "no" or exclude = c(NA, NaN)), then the proportions will be
based on the number of observed elements.}

\item{sort}{character vector of length 1 specifying how the returned table
will be sorted. There are three options: 1) "frequency" = the frequency of
the unique values in \code{x}, 2) "position" = the position when each
unique value first appears in \code{x}, 3) "alphanum" = alphanumeric
ordering of the unique values in \code{x} (the sorting used by
\code{table}). When "frequency" is specified and there are ties, then the
ties are sorted alphanumerically.}

\item{decreasing}{logical vector of length 1 specifying whether the table
should be sorted in decreasing (TRUE) or increasing (FALSE) order.}

\item{na.last}{logical vector of length 1 specifying whether the table should
have NAs last or in whatever position they end up at. This argument is only
relevant if NAs exist in \code{x} and are included in the table (e.g.,
useNA = "always" or exclude = NULL).}
}
\value{
list of numeric vector of frequencies by group. The number of list
  elements are the groups specified by \code{unique(interaction(grp, sep =
  sep))}. The frequencies either counts (if \code{prop} = FALSE) or
  proportions (if \code{prop} = TRUE) with the unique values of \code{x} as
  names (missing values have name = "(NA)"). Note, this is different from
  \code{table}, which returns a 1D-array and has class "table".
}
\description{
\code{tables_by} creates a frequency table for a set of variables in a
data.frame by group. Depending on \code{total}, frequencies for all the
variables together can be returned by group. The function probably makes the
most sense for sets of variables with similar unique values (e.g., items from
a questionnaire with similar response options).
}
\details{
\code{tables_by} uses \code{plyr::rbind.fill} to combine the results from
\code{table} applied to each variable into a single data.frame for each
group. If a variable from \code{data[vrb.nm]} for each group does not have
values present in other variables from \code{data[vrb.nm]} for that group,
then the frequencies in the return object will be 0.

The name for the table element giving the frequency of missing values is
"(NA)". This is different from \code{table} where the name is
\code{NA_character_}. This change allows for the sorting of tables that
include missing values, as subsetting in R is not possible with
\code{NA_character_} names. In future versions of the package, this might
change as it should be possible to avoid this issue by subetting with a
logical vector or integer indices instead of names. However, it is convenient
to be able to subset the return object fully by names.
}
\examples{
x <- freq_by(mtcars$"gear", grp = mtcars$"vs")
str(x)
y <- freq_by(mtcars$"am", grp = mtcars$"vs", useNA = "no")
str(y)
str2str::lv2m(lapply(X = y, FUN = rev), along = 1) # ready to pass to prop.test()
}
\seealso{
\code{\link{freq}}
   \code{\link{freq_by}}
   \code{\link{freqs_by}}
   \code{\link{table}}
}
