% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-LagEstimator.R
\docType{methods}
\name{getPointwiseCIs-LagEstimator}
\alias{getPointwiseCIs,LagEstimator-method}
\alias{getPointwiseCIs-LagEstimator}
\title{Get pointwise confidence intervals for the quantile spectral density kernel}
\usage{
\S4method{getPointwiseCIs}{LagEstimator}(object, frequencies = 2 * pi *
  (0:(length(object@Y) - 1))/length(object@Y), levels.1 = getLevels(object,
  1), levels.2 = getLevels(object, 2), alpha = 0.1, type = c("naive.sd",
  "boot.sd", "boot.full"))
}
\arguments{
\item{object}{\code{LagEstimator} of which to get the confidence intervals}

\item{frequencies}{a vector of frequencies for which to get the result}

\item{levels.1}{the first vector of levels for which to get the result}

\item{levels.2}{the second vector of levels for which to get the result}

\item{alpha}{the level of the confidence interval; must be from \eqn{(0,1)}}

\item{type}{a flag indicating which type of confidence interval should be
returned; can only take one values at the moment.}
}
\value{
Returns a named list of two arrays \code{lowerCIS} and \code{upperCIs}
         containing the lower and upper bounds for the confidence intervals.
}
\description{
Returns a list of two arrays \code{lowerCIs} and \code{upperCIs} that contain
the upper and lower limits for a level \code{1-alpha} confidence interval of
the copula spectral density kernel. Each array is of dimension \code{[J,K1,K2]},
where \code{J=length(frequencies)}, \code{K1=length(levels.1)}, and
\code{K2=length(levels.2))}.
At position \code{(j,k1,k2)} the real (imaginary) part of the returned values
are the bounds of the confidence interval for the the real (imaginary) part
of the quantile spectrum, which corresponds to
\code{frequencies[j]}, \code{levels.1[k1]} and \code{levels.2[k2]} closest
to the Fourier frequencies, \code{levels.1} and \code{levels.2}
available in \code{object}; \code{\link{closest.pos}} is used to determine
what closest to means.
}
\details{
Currently, only one \code{type} of confidence interval is
available:
\itemize{
  \item \code{"naive.sd"}: confidence intervals based on the asymptotic
          normality of the lag-window estimator; standard deviations
          are estimated using \code{\link{getSdNaive}}.
 }
}
\examples{
lagEst <- lagEstimator(rnorm(2^10), levels.1=0.5)
CI.upper <- Re(getPointwiseCIs(lagEst)$upperCIs[,1,1])
CI.lower <- Re(getPointwiseCIs(lagEst)$lowerCIs[,1,1])
freq = 2*pi*(0:1023)/1024
plot(x = freq, y = rep(0.25/(2*pi),1024),
   ylim=c(min(CI.lower), max(CI.upper)),
   type="l", col="red") # true spectrum
lines(x = freq, y = CI.upper)
lines(x = freq, y = CI.lower)
}
\keyword{Access-functions}

