% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nfunctions.R
\name{ndoc}
\alias{ndoc}
\alias{nfeat}
\title{Count the number of documents or features}
\usage{
ndoc(x)

nfeat(x)
}
\arguments{
\item{x}{a \pkg{quanteda} object: a \link{corpus}, \link{dfm}, \link{tokens}, or
\link{tokens_xptr} object, or a readtext object from the \pkg{readtext} package}
}
\value{
\code{ndoc()} returns an integer count of the number of documents in an
object whose texts are organized as "documents" (a \link{corpus}, \link{dfm}, or
\link{tokens}/\link{tokens_xptr} object.

\code{nfeat()} returns an integer count of the number of features.  It is
an alias for \code{ntype()} for a dfm. This function is only defined for \link{dfm}
objects because only these have "features".
}
\description{
Get the number of documents or features in an object.
}
\examples{
# number of documents
ndoc(data_corpus_inaugural)
ndoc(corpus_subset(data_corpus_inaugural, Year > 1980))
ndoc(tokens(data_corpus_inaugural))
ndoc(dfm(tokens(corpus_subset(data_corpus_inaugural, Year > 1980))))

# number of features
toks1 <- tokens(corpus_subset(data_corpus_inaugural, Year > 1980), remove_punct = FALSE)
toks2 <- tokens(corpus_subset(data_corpus_inaugural, Year > 1980), remove_punct = TRUE)
nfeat(dfm(toks1))
nfeat(dfm(toks2))
}
\seealso{
\code{\link[=ntoken]{ntoken()}}, \code{\link[=ntype]{ntype()}}
}
