% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{check_integer}
\alias{check_integer}
\alias{check_double}
\alias{check_logical}
\alias{check_character}
\title{Validate input vectors}
\usage{
check_integer(
  x,
  min_len = 1,
  max_len = 1,
  min = -Inf,
  max = Inf,
  strict = FALSE,
  allow_null = FALSE
)

check_double(
  x,
  min_len = 1,
  max_len = 1,
  min = -Inf,
  max = Inf,
  strict = FALSE,
  allow_null = FALSE
)

check_logical(
  x,
  min_len = 1,
  max_len = 1,
  strict = FALSE,
  allow_null = FALSE,
  allow_na = FALSE
)

check_character(
  x,
  min_len = 1,
  max_len = 1,
  min_nchar = 0,
  max_nchar = Inf,
  strict = FALSE,
  allow_null = FALSE
)
}
\arguments{
\item{min_len}{minimum length of the vector}

\item{max_len}{maximum length of the vector}

\item{min}{minimum value in the vector}

\item{max}{maximum value in the vector}

\item{strict}{raise error when \code{x} is a different type}

\item{allow_null}{if \code{TRUE}, returns \code{NULL} when \code{is.null(x)}}

\item{allow_na}{if \code{TRUE}, convert \code{NA} to \code{FALSE}}

\item{min_nchar}{minimum character length of values in the vector}

\item{max_nchar}{maximum character length of values in the vector}
}
\description{
Check the range of values and the length of input vectors
before used in control flow or passed to C++ functions.
}
\details{
Note that value checks are performed after coercion to expected input types.
}
\examples{
\dontrun{
check_integer(0, min = 1) # error
check_integer(-0.1, min = 0) # return 0
check_double(-0.1, min = 0) # error
check_double(numeric(), min_len = 0) # return numeric()
check_double("1.1", min = 1) # returns 1.1
check_double("1.1", min = 1, strict = TRUE) # error
check_double("xyz", min = 1) # error
check_logical(c(TRUE, FALSE), min_len = 3) # error
check_character("_", min_nchar = 1) # return "_"
check_character("", min_nchar = 1) # error
}
}
\keyword{development}
\keyword{internal}
