% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm_replace.R
\name{dfm_replace}
\alias{dfm_replace}
\title{Replace features in dfm}
\usage{
dfm_replace(
  x,
  pattern,
  replacement,
  case_insensitive = TRUE,
  verbose = quanteda_options("verbose")
)
}
\arguments{
\item{x}{\link{dfm} whose features will be replaced}

\item{pattern}{a character vector.  See \link{pattern}
for more details.}

\item{replacement}{if \code{pattern} is a character vector, then
\code{replacement} must be character vector of equal length, for a 1:1
match.}

\item{case_insensitive}{logical; if \code{TRUE}, ignore case when matching a
\code{pattern} or \link{dictionary} values}

\item{verbose}{print status messages if \code{TRUE}}
}
\description{
Substitute features based on vectorized one-to-one matching for lemmatization
or user-defined stemming.
}
\examples{
dfmat1 <- dfm(tokens(data_corpus_inaugural))

# lemmatization
taxwords <- c("tax", "taxing", "taxed", "taxed", "taxation")
lemma <- rep("TAX", length(taxwords))
featnames(dfm_select(dfmat1, pattern = taxwords))
dfmat2 <- dfm_replace(dfmat1, pattern = taxwords, replacement = lemma)
featnames(dfm_select(dfmat2, pattern = taxwords))

# stemming
feat <- featnames(dfmat1)
featstem <- char_wordstem(feat, "porter")
dfmat3 <- dfm_replace(dfmat1, pattern = feat, replacement = featstem, case_insensitive = FALSE)
identical(dfmat3, dfm_wordstem(dfmat1, "porter"))
}
