% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-methods.R
\name{topfeatures}
\alias{topfeatures}
\title{Identify the most frequent features in a dfm}
\usage{
topfeatures(
  x,
  n = 10,
  decreasing = TRUE,
  scheme = c("count", "docfreq"),
  groups = NULL
)
}
\arguments{
\item{x}{the object whose features will be returned}

\item{n}{how many top features should be returned}

\item{decreasing}{If \code{TRUE}, return the \code{n} most frequent features;
otherwise return the \code{n} least frequent features}

\item{scheme}{one of \code{count} for total feature frequency (within
\code{group} if applicable), or \code{docfreq} for the document frequencies
of features}

\item{groups}{grouping variable for sampling, equal in length to the number
of documents. This will be evaluated in the docvars data.frame, so that
docvars may be referred to by name without quoting. This also changes
previous behaviours for \code{groups}. See \code{news(Version >= "3.0", package = "quanteda")} for details.}
}
\value{
A named numeric vector of feature counts, where the names are the
feature labels, or a list of these if \code{groups} is given.
}
\description{
List the most (or least) frequently occurring features in a \link{dfm}, either
as a whole or separated by document.
}
\examples{
dfmat1 <- corpus_subset(data_corpus_inaugural, Year > 1980) \%>\%
    tokens(remove_punct = TRUE) \%>\%
    dfm()
dfmat2 <- dfm_remove(dfmat1, stopwords("en"))

# most frequent features
topfeatures(dfmat1)
topfeatures(dfmat2)

# least frequent features
topfeatures(dfmat2, decreasing = FALSE)

# top features of individual documents
topfeatures(dfmat2, n = 5, groups = docnames(dfmat2))

# grouping by president last name
topfeatures(dfmat2, n = 5, groups = President)

# features by document frequencies
tail(topfeatures(dfmat1, scheme = "docfreq", n = 200))
}
