% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus-addsummary-metadata.R
\name{summary_metadata}
\alias{summary_metadata}
\alias{add_summary_metadata}
\alias{get_summary_metadata}
\alias{summarize_texts_extended}
\title{Functions to add or retrieve corpus summary metadata}
\usage{
add_summary_metadata(x, extended = FALSE, ...)

get_summary_metadata(x, ...)

summarize_texts_extended(x, stop_words = stopwords("en"), n = 100)
}
\arguments{
\item{x}{\link{corpus} object}

\item{...}{additional arguments passed to \code{\link[=tokens]{tokens()}} when computing the
summary information}
}
\value{
\code{add_summary_metadata()} returns a corpus with summary metadata added
as a data.frame, with the top-level list element names \code{summary}.

\code{get_summary_metadata()} returns the summary metadata as a data.frame.

\code{summarize_texts_extended()} returns extended summary information.
}
\description{
Functions to add or retrieve corpus summary metadata
}
\details{
This is provided so that a \link{corpus} object can be stored with
summary information to avoid having to compute this every time
\verb{[summary.corpus()]} is called.

So in future calls, if \verb{!is.null(meta(x, "summary", type = "system") && !length(list(...))}, then \code{summary.corpus()} will simply return
\code{get_system_meta()} rather than compute the summary statistics on the fly,
which requires tokenizing the text.
}
\examples{
corp <- corpus(data_char_ukimmig2010)
corp <- quanteda:::add_summary_metadata(corp)
quanteda:::get_summary_metadata(corp)
#' 
\dontrun{
# using extended summary

extended_data <- quanteda:::summarize_texts_extended(data_corpus_inaugural)

textplot_wordcloud(extended_data$top_dfm, max_words = 100)

ggplot2::ggplot(data.frame(extended_data$all_tokens), aes(x = all_tokens)) +
   geom_histogram(color = "darkblue", fill = "lightblue") +
   xlab("Total length in tokens"
}
}
\keyword{corpus}
\keyword{internal}
