% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-classes.R
\name{as.matrix.dfm}
\alias{as.matrix.dfm}
\alias{as.data.frame.dfm}
\title{coerce a dfm to a matrix or data.frame}
\usage{
\method{as.matrix}{dfm}(x, ...)

\method{as.data.frame}{dfm}(x, row.names = NULL, ...)
}
\arguments{
\item{x}{dfm to be coerced}

\item{...}{unused}

\item{row.names}{if \code{FALSE}, do not set the row names of the data.frame
to the docnames of the dfm (default); or a vector of values to which the
row names will be set.}
}
\description{
Methods for coercing a \link{dfm} object to a matrix or data.frame object.
}
\examples{
# coercion to matrix
mydfm <- dfm(data_corpus_inaugural)
str(as.matrix(mydfm))

# coercion to a data.frame
inaugDfm <- dfm(data_corpus_inaugural[1:5])
as.data.frame(inaugDfm[, 1:10])
as.data.frame(inaugDfm[, 1:10], row.names = FALSE)
}
\keyword{dfm}
