% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus.R, R/dfm-methods.R
\name{ndoc}
\alias{ndoc}
\alias{ndoc.corpus}
\alias{ndoc.dfm}
\alias{nfeature}
\alias{nfeature.corpus}
\alias{nfeature.dfm}
\title{get the number of documents or features}
\usage{
ndoc(x)

\method{ndoc}{corpus}(x)

\method{ndoc}{dfm}(x)

nfeature(x)

\method{nfeature}{corpus}(x)

\method{nfeature}{dfm}(x)
}
\arguments{
\item{x}{a corpus or dfm object}
}
\value{
an integer (count) of the number of documents or features in the corpus or dfm
}
\description{
\code{ndoc} returns the number of documents or features in a quanteda object, which can be 
a corpus, dfm, or tokenized texts.

\code{nfeature} is an alias for \code{ntype} when applied to dfm
  objects.  For a corpus or set of texts, "features" are only defined through
  tokenization, so you need to use \code{\link{ntoken}} to count these.
}
\examples{
ndoc(subset(inaugCorpus, Year>1980))
ndoc(dfm(subset(inaugCorpus, Year>1980), verbose=FALSE))
nfeature(dfm(inaugCorpus))
nfeature(trim(dfm(inaugCorpus), minDoc=5, minCount=10))
}

