% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clean.R
\name{clean}
\alias{clean}
\alias{clean.character}
\alias{clean.corpus}
\alias{cleanC}
\title{simple cleaning of text before processing}
\usage{
clean(x, ...)

\method{clean}{character}(x, removeDigits = TRUE, removePunct = TRUE,
  toLower = TRUE, removeAdditional = NULL, removeTwitter = FALSE,
  removeURL = TRUE, ...)

\method{clean}{corpus}(x, removeDigits = TRUE, removePunct = TRUE,
  toLower = TRUE, removeAdditional = NULL, removeTwitter = FALSE, ...)

cleanC(x, removeDigits = TRUE, removePunct = TRUE, toLower = TRUE,
  removeAdditional = NULL, removeTwitter = FALSE, removeURL = TRUE, ...)
}
\arguments{
\item{x}{The object to be cleaned. Can be either a character vector or a
corpus containing texts}

\item{...}{additional parameters}

\item{removeDigits}{remove numbers if \code{TRUE}}

\item{removePunct}{remove punctuation if \code{TRUE}}

\item{toLower}{convert text to lower case \code{TRUE}}

\item{removeAdditional}{additional characters to remove (\link[=regex]{regular expression})}

\item{removeTwitter}{if \code{FALSE}, do not remove \code{@} or \code{#'}}

\item{removeURL}{removes URLs (web addresses starting with \code{http:} or \code{https:}), based
on a regular expression from \url{http://daringfireball.net/2010/07/improved_regex_for_matching_urls}}
}
\value{
A character vector equal in length to the original texts (supplied or in the corpus)
after cleaning.
}
\description{
\code{clean} is an older function used for pre-processing text, but now replaced by similar functionality in
\code{\link{tokenize}}.  Please use that function instead.
}

