% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_survey.R
\name{fetch_survey}
\alias{fetch_survey}
\title{Download a survey and import it into R}
\usage{
fetch_survey(surveyID, last_response = NULL, start_date = NULL,
  end_date = NULL, unanswer_recode = NULL, limit = NULL,
  include_questions = NULL, save_dir = NULL, force_request = FALSE,
  verbose = TRUE, label = TRUE, convert = TRUE, local_time = FALSE,
  ...)
}
\arguments{
\item{surveyID}{String. Unique ID for the survey you want to download.
Returned as \code{id} by the \link[qualtRics]{all_surveys} function.}

\item{last_response}{String. Export all responses received after the
specified response ID. Defaults to \code{NULL}.}

\item{start_date}{String. Filter to only exports responses recorded after the
specified date. Accepts dates as character strings in format "YYYY-MM-DD".
Defaults to \code{NULL}.}

\item{end_date}{String. Filter to only exports responses recorded before the
specified date. Accepts dates as character strings in format "YYYY-MM-DD".
Defaults to \code{NULL}.}

\item{unanswer_recode}{String. Recode seen but unanswered questions with a
string value. Defaults to \code{NULL}.}

\item{limit}{Integer. Maximum number of responses exported. Defaults to
\code{NULL} (all responses).}

\item{include_questions}{Vector of strings (e.g. c('QID1', 'QID2', 'QID3').
Export only specified questions. Defaults to \code{NULL}.}

\item{save_dir}{String. Directory where survey results will be stored.
Defaults to a temporary directory which is cleaned when your R session is
terminated. This argument is useful if you'd like to store survey results.
The downloaded survey will be stored as an RDS file (see
\code{\link[base]{readRDS}}).}

\item{force_request}{Logical. fetch_survey() saves each survey in a temporary
directory so that it can quickly be retrieved later. If force_request is
\code{TRUE}, fetch_survey() always downloads the survey from the API instead
of loading it from the temporary directory. Defaults to \code{FALSE}.}

\item{verbose}{Logical. If \code{TRUE}, verbose messages will be printed to
the R console. Defaults to \code{TRUE}.}

\item{label}{Logical. \code{TRUE} to export survey responses as Choice Text
or \code{FALSE} to export survey responses as values.}

\item{convert}{Logical. If \code{TRUE}, then the
\code{\link[qualtRics]{fetch_survey}} function will convert certain question
types (e.g. multiple choice) to proper data type in R. Defaults to \code{TRUE}.}

\item{local_time}{Logical. Use local timezone to determine response date
values? Defaults to \code{FALSE}. See
\url{https://api.qualtrics.com/docs/dates-and-times} for more information.}

\item{...}{optional arguments. You can pass all arguments listed in
\code{\link{registerOptions}} (except a different base url / api key).
You can also pass a argument 'fileEncoding' (see 'fileEncoding' argument in
\code{\link[qualtRics]{read_survey}}) to import your survey using a specific encoding.}
}
\description{
Download a Qualtrics survey you own via API and import the survey directly into R.
}
\examples{
\dontrun{
# Register your Qualtrics credentials if you haven't already
qualtrics_api_credentials(
  api_key = "<YOUR-API-KEY>",
  base_url = "<YOUR-BASE-URL>"
)

# Retrieve a list of surveys
surveys <- all_surveys()

# Retrieve a single survey
mysurvey <- fetch_survey(surveyID = surveys$id[6])

mysurvey <- fetch_survey(
  surveyID = surveys$id[6],
  save_dir = tempdir(),
  start_date = "2018-01-01",
  end_date = "2018-01-31",
  limit = 100,
  label = TRUE,
  unanswer_recode = "UNANS",
  verbose = TRUE
)
}

}
\seealso{
See \url{https://api.qualtrics.com/docs/response-exports} for documentation on the Qualtrics API.
}
